#include "dis48.h"
#include <fcntl.h>

void
#ifdef ANSI
StuffNybble(char *mem, NAddr addr, Nybble n)
#else
StuffNybble(mem, addr, n)
char	*mem;
NAddr	addr;
Nybble	n;
#endif
{
	char	t;
	
	t = mem[addr >> 1] & ((addr & 1) ? 0x0f : 0xf0);
	n &= 0xf;
	if (addr & 1)
		n <<= 4;
		
	mem[addr >> 1] = t | n;
}

#define NSIZE 524288
#define BSIZE (NSIZE / 2)

Bitmap	completed;
int	dopause = 0;

#ifdef ANSI
main(int argc, char **argv)
#else
main(argc, argv)
int	argc;
char	**argv;
#endif
{
	char	*p;
	int	n;
	NAddr	a;
	char	buf[80];
	char	mem[80];

	while (1) {
		fprintf(stderr, "?\n");
		if (fgets(buf, sizeof(buf), stdin) == NULL)
			break;
			
		for (a = 0, p = buf; (*p != '\n') && (*p != '\0'); a++, p++) {
			if ((*p >= '0') && (*p <= '9'))
				*p -= '0';
			
			else if ((*p >= 'A') && (*p <= 'F'))
				*p -= 'A' - 10;
				
			else if ((*p >= 'a') && (*p <= 'f'))
				*p -= 'a' - 10;
				
			StuffNybble(mem, a, *p);
		}
			
		Object(mem, 0, buf);
		printf("%s\n", buf);
	}
	
	exit(0);
}
