#include "dis48.h"

char *
#ifdef ANSI
Append16(char *buf, int n)
#else
Append16(buf, n)
char	*buf;
int	n;
#endif
{
	if (++n > 9) {
		APPEND_CHAR(buf, '1');
		n -= 10;
	}
	
	APPEND_BDIGIT(buf, n);
	TERMINATE(buf);
	return(buf);
}

char *
#ifdef ANSI
AppendAddr(char *buf, NAddr addr)
#else
AppendAddr(buf, addr)
char	*buf;
NAddr	addr;
#endif
{
	int	mask, shift;
	
	APPEND_HEXMARK(buf);
	for (mask = 0xf0000, shift = 16; mask != 0; mask >>= 4, shift -= 4)
		APPEND_CHAR(buf, hex[(addr & mask) >> shift]);
	
	TERMINATE(buf);
	return(buf);
}

char *
#ifdef ANSI
AppendRAddr(char *buf, NAddr pc, int disp, int n, int offset)
#else
AppendRAddr(buf, pc, disp, n, offset)
char	*buf;
NAddr	pc;
int	disp;
int	n;
int	offset;
#endif
{
	int	sign;
	
	sign = 1 << (n * 4 - 1);
	if (disp & sign)
		disp |= ~(sign - 1);
		
	pc += disp;
	target = pc;
	buf = AppendStr(buf, "pc");
	if (disp < 0) {
		APPEND_CHAR(buf, '-');
		disp = -disp - offset;
	} else {
		APPEND_CHAR(buf, '+');
		disp += offset;
	}
		
	buf = AppendAddr(buf, disp);
	buf = AppendStr(buf, " (");
	buf = AppendAddr(buf, pc);
	APPEND_CHAR(buf, ')');
	TERMINATE(buf);
	return(buf);
}

char *
#ifdef ANSI
AppendField(char *buf, Nybble fn)
#else
AppendField(buf, fn)
char	*buf;
Nybble	fn;
#endif
{
	while (*buf != '\0')
		buf++;
		
	APPEND_CHAR(buf, '.');
	switch (fn) {
	case 1: APPEND_CHAR(buf, 'x'); /* fall through */
	case 0: APPEND_CHAR(buf, 'p'); break;
	case 2:
	case 3:
		APPEND_CHAR(buf, 'x');
		if (fn == 3)
			break;
			
		/* fall through */
	case 4: APPEND_CHAR(buf, 's'); break;
	case 5: APPEND_CHAR(buf, 'm'); break;
	case 6: APPEND_CHAR(buf, 'b'); break;
	case 7: APPEND_CHAR(buf, 'w'); break;
	case 0xf: APPEND_CHAR(buf, 'a'); break;
	default: APPEND_CHAR(buf, '?'); break;
	}
	
	APPEND_TAB(buf);
	TERMINATE(buf);
	return(buf);
}

char *
#ifdef ANSI
AppendHexNyb(char *buf, char *mem, NAddr *addr, int n)
#else
AppendHexNyb(buf, mem, addr, n)
char	*buf;
char	*mem;
NAddr	*addr;
int	n;
#endif
{
	int	i;
	Nybble	t[16];
	
	APPEND_HEXMARK(buf);
	for (i = 0; i < n; i++)
		t[i] = GetNybble(mem, (*addr)++);
	
	while (--i >= 0)
		APPEND_CHAR(buf, hex[t[i]]);

	TERMINATE(buf);
	return(buf);
}

char *
#ifdef ANSI
AppendDecInt(char *buf, int n)
#else
AppendDecInt(buf, n)
char	*buf;
int	n;
#endif
{
	int	i;
	char	b[9];
	
	if (n < 0) {
		APPEND_CHAR(buf, '-');
		n = -n;
	}
	
	for (i = 0; n != 0; i++, n /= 10)
		b[i] = n % 10 + '0';
	
	while (--i >= 0)
		APPEND_CHAR(buf, b[i]);

	TERMINATE(buf);
	return(buf);
}

char *
#ifdef ANSI
AppendImmNyb(char *buf, char *mem, NAddr *addr, int n)
#else
AppendImmNyb(buf, mem, addr, n)
char	*buf;
char	*mem;
NAddr	*addr;
int	n;
#endif
{
	APPEND_IMMMARK(buf);
	return(AppendHexNyb(buf, mem, addr, n));
}

#define NSTBIT	4
char	*StBitStr[NSTBIT] = {"xm", "sb", "sr", "mp"};

char *
#ifdef ANSI
AppendStBits(char *buf, int n)
#else
AppendStBits(buf, n)
char	*buf;
int	n;
#endif
{
	int	i;
	char	*p, *q;
	
	for (p = buf, i = 0; i < NSTBIT; i++)
		if (n & (1 << i)) {
			if (p != buf) {
				APPEND_COMMA(p);
			}
			
			/* p = AppendStr(p, StBitStr[i]); */
			q = StBitStr[i];
			while (*p = *q++)
				p++;
		}
	
	TERMINATE(p);
	return(p);
}

char *
#ifdef ANSI
AppendStr(char *buf, char *str)
#else
AppendStr(buf, str)
char	*buf;
char	*str;
#endif
{
	while (*buf = *str++)
		buf++;
	
	return(buf);
}
