/* Stuff specific to the 3Com 3C509 Ethernet controller board */

#if (ETHERNET == ETH_3C509)

/* Command code masks */

#define CMD_CMDMASK             0xF800                  /* command bits */
#define CMD_ARGMASK             0x07FF                  /* argument bits */

/* Command codes, word form */

#define CMD_GLOBALRESET         0x0000                 /* global reset */
#define CMD_SELECTWINDOW        0x0800                 /* select register window */
#define CMD_STARTINTXCVR        0x1000                 /* start internal transciver */
#define CMD_RXDISABLE           0x1800                 /* rx disable */
#define CMD_RXENABLE            0x2000                 /* rx enable */
#define CMD_RXRESET             0x2800                 /* rx reset */
#define CMD_RXDISCARD           0x4000                 /* rx discard top packet */
#define CMD_TXENABLE            0x4800                 /* tx enable */
#define CMD_TXDISABLE           0x5000                 /* tx disable */
#define CMD_TXRESET             0x5800                 /* tx reset */
#define CMD_REQUESTINT          0x6000                 /* request interrupt */
#define CMD_ACKNOWLEDGE         0x6800                 /* acknowledge interrupt */
#define CMD_SETINTMASK          0x7000                 /* set interrupt mask */
#define CMD_SETRZMASK           0x7800                 /* set read zero mask */
#define CMD_SETRXFILTER         0x8000                 /* set rx filter */
#define CMD_SETRXEARLY          0x8800                 /* set rx early threshold */
#define CMD_SETTXAVAILABLE      0x9000                 /* set tx available threshold */
#define CMD_SETTXSTART          0x9800                 /* set tx start threshold */
#define CMD_STATSENABLE         0xA800                 /* statistics enable */
#define CMD_STATSDISABLE        0xB000                 /* statistics disable */
#define CMD_STOPINTXCVR         0xB800                 /* start internal transciver */

/* Command codes, hibyte form (commands without operands only) */

#define CMDH_STARTINTXCVR       (CMD_STARTINTXCVR >> 8)
#define CMDH_RXDISABLE          (CMD_RXDISABLE >> 8)
#define CMDH_RXENABLE           (CMD_RXENABLE >> 8)
#define CMDH_RXDISCARD          (CMD_RXDISCARD >> 8)
#define CMDH_TXENABLE           (CMD_TXENABLE >> 8)
#define CMDH_TXDISABLE          (CMD_TXDISABLE >> 8)
#define CMDH_REQUESTINT         (CMD_REQUESTINT >> 8)
#define CMDH_STATSENABLE        (CMD_STATSENABLE >> 8)
#define CMDH_STATSDISABLE       (CMD_STATSDISABLE >> 8)
#define CMDH_STOPINTXCVR        (CMD_STOPINTXCVR >> 8)

/* Status register bits (INT for interrupt sources, ST for the rest) */

#define INT_LATCH               0x0001                  /* interrupt latch */
#define INT_ADAPTERFAIL         0x0002                  /* adapter failure */
#define INT_TXCOMPLETE          0x0004                  /* tx complete */
#define INT_TXAVAILABLE         0x0008                  /* tx available */
#define INT_RXCOMPLETE          0x0010                  /* rx complete */
#define INT_RXEARLY             0x0020                  /* rx early */
#define INT_REQUESTED           0x0040                  /* interrupt requested */
#define INT_UPDATESTATS         0x0080                  /* update statistics */
#define ST_FAILED               0x0800                  /* command failed */
#define ST_BUSY                 0x1000                  /* command busy */
#define ST_WINDOW               0xE000                  /* window bits (13-15) */

#define STH_FAILED              (ST_FAILED >> 8)
#define STH_BUSY                (ST_BUSY >> 8)
#define STH_WINDOW              (ST_WINDOW >> 8)


/* RxStatus register bits */

#define RXS_INCOMPLETE          0x8000                   /* not completely received */
#define RXS_ERROR               0x4000                   /* error in packet */
#define RXS_LENGTH              0x07FF                   /* bytes in RxFIFO */
#define RXS_ERRTYPE             0x3800                   /* Rx error type, bit 13-11 */
#define RXS_OVERRUN             0x0000                   /* overrun error */
#define RXS_OVERSIZE            0x0800                   /* oversize packet error */
#define RXS_DRIBBLE             0x1000                   /* dribble bit (not an error) */
#define RXS_RUNT                0x1800                   /* runt packet error */
#define RXS_CRC                 0x2800                   /* CRC error */
#define RXS_FRAMING             0x2000                   /* framing error */

#define RXSH_INCOMPLETE         (RXS_INCOMPLETE >> 8)
#define RXSH_ERROR              (RXS_ERROR >> 8)
#define RXSH_ERRTYPE            (RXS_ERRTYPE >> 8)
#define RXSH_OVERRUN            (RXS_OVERRUN >> 8)
#define RXSH_DRIBBLE            (RXS_DRIBBLE >> 8)
#define RXSH_CRC                (RXS_CRC >> 8)
#define RXSH_RUNT               (RXS_RUNT >> 8)
#define RXSH_OVERSIZE           (RXS_OVERSIZE >> 8)
#define RXSH_FRAMING            (RXS_FRAMING >> 8)

/* TxStatus register bits */

#define TXS_COMPLETE            0x80                     /* tx completed */
#define TXS_INTREQUESTED        0x40                     /* interrupt on successfull tx */
#define TXS_ERRTYPE             0x38                     /* error bits */
#define TXS_JABBERERROR         0x20                     /* jabber error */
#define TXS_UNDERRUN            0x10                     /* tx underrun error */
#define TXS_MAXCOLLISIONS       0x08                     /* max collisions error */
#define TXS_STATUSOVERFLOW      0x04                     /* TX status stack is full */

/* Window Numbers */

#define WNO_SETUP               0                       /* setup/configuration */
#define WNO_OPERATING           1                       /* operating set */
#define WNO_STATIONADDRESS      2                       /* station address setup/read */
#define WNO_FIFO                3                       /* FIFO management */
#define WNO_DIAGNOSTICS         4                       /* diagnostics */
#define WNO_READABLE            5                       /* registers set by commands */
#define WNO_STATISTICS          6                       /* statistics */

/* Port offsets, Window 1 (WNO_OPERATING) */

#define PORT_CmdStatus          0x0E                     /* command/status */
#define PORT_TxFree             0x0C                     /* free transmit bytes */
#define PORT_TxStatus           0x0B                     /* transmit status (byte) */
#define PORT_Timer              0x0A                     /* latency timer (byte) */
#define PORT_RxStatus           0x08                     /* receive status */
#define PORT_RxFIFO             0x00                     /* RxFIFO read */
#define PORT_TxFIFO             0x00                     /* TxFIFO write */

/* Port offsets, Window 0 (WNO_SETUP) */

#define PORT_EEData             0x0C                     /* EEProm data register */
#define PORT_EECmd              0x0A                     /* EEProm command register */
#define PORT_CfgResource        0x08                     /* resource configuration */
#define PORT_CfgAddress         0x06                     /* address configuration */
#define PORT_CfgControl         0x04                     /* configuration control */
#define PORT_ProductID          0x02                     /* product id (EISA) */
#define PORT_Manufacturer       0x00                     /* Manufacturer code (EISA) */

/* Port offsets, Window 2 (WNO_STATIONADDRESS) */

#define PORT_SA0_1              0x00                     /* station address bytes 0,1 */
#define PORT_SA2_3              0x02                     /* station address bytes 2,3 */
#define PORT_SA4_5              0x04                     /* station address bytes 4,5 */

/* Port offsets, Window 3 (WNO_FIFO) */

#define PORT_ALT_TxFree         0x0C                     /* free transmit bytes (dup) */
#define PORT_RxFree             0x0A                     /* free receive bytes */

/* Port offsets, Window 4 (WNO_DIAGNOSTICS) */

#define PORT_MediaStatus        0x0A                     /* media type/status */
#define PORT_SlingshotStatus    0x08                     /* Slingshot status */
#define PORT_NetDiagnostic      0x06                     /* net diagnostic */
#define PORT_FIFODiagnostic     0x04                     /* FIFO diagnostic */
#define PORT_HostDiagnostic     0x02                     /* host diagnostic */
#define PORT_TxDiagnostic       0x00                     /* tx diagnostic */

/* Port offsets, Window 5 (WNO_READABLE) */

#define PORT_RZMask             0x0C                     /* read zero mask */
#define PORT_IntMask            0x0A                     /* interrupt mask */
#define PORT_RxFilter           0x08                     /* receive filter */
#define PORT_RxEarly            0x06                     /* rx early threshold */
#define PORT_TxAvailable        0x02                     /* tx available threshold */
#define PORT_TxStart            0x00                     /* tx start threshold */

/* Port offsets, Window 6 (WNO_STATISTICS) */

#define PORT_TXBYTES            0x0C                     /* tx bytes ok */
#define PORT_RXBYTES            0x0A                     /* rx bytes ok */
#define PORT_TXDEFER            0x08                     /* tx frames deferred (byte) */
#define PORT_RXFRAMES           0x07                     /* rx frames ok (byte) */
#define PORT_TXFRAMES           0x06                     /* tx frames ok (byte) */
#define PORT_RXDISCARDED        0x05                     /* rx frames discarded (byte) */
#define PORT_TXLATE             0x04                     /* tx frames late coll. (byte) */
#define PORT_TXSINGLE           0x03                     /* tx frames one coll. (byte) */
#define PORT_TXMULTIPLE         0x02                     /* tx frames mult. coll. (byte) */
#define PORT_TXNOCD             0x01                     /* tx frames no CDheartbt (byte) */
#define PORT_TXCARRIERLOST      0x00                     /* tx frames carrier lost (byte) */

/* Various command arguments */

#define INT_ALLDISABLED             0x0000            /* all interrupts disabled */
#define INT_ALLENABLED              0x00FE            /* all interrupts enabled */

#define FILTER_INDIVIDUAL           0x01                   /* individual address */
#define FILTER_MULTICAST            0x02                   /* multicast/group addresses */
#define FILTER_BROADCAST            0x04                   /* broadcast address */
#define FILTER_PROMISCUOUS          0x08                   /* promiscuous mode */

#define RXEARLY_DISABLED            2032                    /* RxEarly to disable */

#define TXAVAIL_DISABLED            2040                    /* TxAvailable to disable */
#define TXAVAIL_MIN                 4

#define TXSTART_DISABLED            2040                    /* TxStart to disable */
#define TXSTART_MIN                 0
#define TXSTART_MAX                 TXSTART_DISABLED

#define RXLENGTH_MAX                1792                    /* maximum rxlength */

/* Transmit Preamble */

#define PREAMBLESIZE                4                       /* transmit preamble size */
#define TXP_INTONSUCCESS            0x8000                   /* interrupt on successful tx */

/* Bits in various diagnostics registers */

#define MEDIA_TP                    0x8000                   /* TP transciever */
#define MEDIA_BNC                   0x4000                   /* Thinnet transciever */
#define MEDIA_INTENDEC              0x2000                   /* internal encoder/decoder */
#define MEDIA_SQE                   0x1000                   /* SQE present */
#define MEDIA_LBEAT                 0x0800                   /* link beat ok (TP) */
#define MEDIA_POLARITY              0x0400                   /* polarity (TP) */
#define MEDIA_JABBER                0x0200                   /* jabber (TP) */
#define MEDIA_UNSQUELCH             0x0100                   /* unsquelch (TP) */
#define MEDIA_LBEATENABLE           0x0080                   /* link beat enable (TP) */
#define MEDIA_JABBERENABLE          0x0040                   /* jabber enable (TP) */
#define MEDIA_CRS                   0x0020                   /* carrier sense */
#define MEDIA_COLLISION             0x0010                   /* collision */
#define MEDIA_SQEENABLE             0x0008                   /* enable SQE statistics */

#define NETD_EXTLOOPBACK            0x8000                   /* TP external loopback */
#define NETD_ENDECLOOPBACK          0x4000                   /* ENDEC loopback */
#define NETD_CORELOOPBACK           0x2000                   /* ethernet core loopback */
#define NETD_FIFOLOOPBACK           0x1000                   /* FIFO loopback */
#define NETD_TXENABLED              0x0800                   /* tx enabled */
#define NETD_RXENABLED              0x0400                   /* rx enabled */
#define NETD_TXTRANSMITTING         0x0200                   /* tx transmitting */
#define NETD_TXRESETREQD            0x0100                   /* tx reset required */

#define FIFOD_RXRECEIVING           0x8000                   /* rx receiveing */
#define FIFOD_RXUNDERRUN            0x2000                   /* rx underrun */
#define FIFOD_RXSTATUSOVER          0x1000                   /* rx status overrun */
#define FIFOD_RXOVERRUN             0x0800                   /* rx overrun */
#define FIFOD_TXOVERRUN             0x0400                   /* tx overrun */
#define FIFOD_BISTRESULTS           0x00FF                   /* BIST results (mask) */

#define SLING_TXUNDERRUN            0x2000                   /* Slingshot TxUnderrun bit */

/* board identification codes, byte swapped in Rev 0 */

#define EISA_MANUFACTURER_ID        0x6D50                  /* EISA manufacturer code */
#define ISA_PRODUCT_ID              0x9050                  /* Product ID for ISA board */
#define PRODUCT_ID_MASK             0xF0FF                  /* Mask off revision nibble */

/* EEProm access */

#define EE_BUSY                         0x8000                   /* EEProm busy bit in EECmd */
#define EE_TCOM_NODE_ADDR_WORD0         0x00
#define EE_TCOM_NODE_ADDR_WORD1         0x01
#define EE_TCOM_NODE_ADDR_WORD2         0x02
#define EE_VULCAN_PROD_ID               0x03
#define EE_MANUFACTURING_DATA           0x04
#define EE_SERIAL_NUMBER_WORD0          0x05
#define EE_SERIAL_NUMBER_WORD1          0x06
#define EE_MANUFACTURER_CODE            0x07
#define EE_ADDR_CONFIGURATION           0x08
#define EE_RESOURCE_CONFIGURATION       0x09
#define EE_OEM_NODE_ADDR_WORD0          0x0A
#define EE_OEM_NODE_ADDR_WORD1          0x0B
#define EE_OEM_NODE_ADDR_WORD2          0x0C
#define EE_SOFTWARE_CONFIG_INFO         0x0D
#define EE_CWORD                        0x0E

/* contention logic */

#define READ_EEPROM                 0x80
#define ID_GLOBAL_RESET		    0xC0
#define SET_TAG_REGISTER            0xD0
#define TEST_TAG_REGISTER           0xD8
#define ACTIVATE_AND_SET_IO         0xE0
#define ACTIVATE_VULCAN             0xFF

/* Resource Configuration Register bits */

#define RCONFIG_IRQ                 0xF000

/* Address Configuration Register bits */

#define ACONFIG_XCVR                0xC000
#define ACONFIG_IOBASE              0x001F

#define IOBASE_EISA                 0x001F

#define TP_XCVR                     0x0000
#define BNC_XCVR                    0xC000
#define AUI_XCVR                    0x4000

#define MIN_IO_BASE_ADDR            0x200
#define MAX_IO_BASE_ADDR            0x3F0
#define REGISTER_SET_SIZE           0x10

/* Software Configuration Register bits */

#define SW_OPTIMIZE                 0x0030
#define SW_MAXCLI                   0x3F00
#define SW_LINKBEAT                 0x4000

/* Possibilities for SW_OPTIMIZE */

#define OPTIMIZE_DOS_CLIENT         0x0010
#define OPTIMIZE_WINDOWS_CLIENT     0x0020
#define OPTIMIZE_SERVER             0x0030

/* Configuration Control Register bits */

#define ENABLE_ADAPTER              0x01

#endif  /* ETH_3C509 */
