#!./ising -f
#-----------------------------------------------------------------------------
#
#	the Visual Ising Machine (VIM)
#
#	versie 0.6
#
#	user interface source script (TCL)
#
#	M.Figee en M.Hufken
#
#-----------------------------------------------------------------------------

source settings.tcl

#set VIM_PATH /user/huffi/tcl/vim06
#set TIX_PATH /user/huffi/tcl/Tix3.6a
set auto_path "$VIM_PATH $auto_path"
#set BITMAP_PATH /user/huffi/bitmaps
set MAIN ".vim"
set RemoteInterp "vimdraw.tcl"

#-----------------------------------------------------------------------------
#  Load the bindings for "studbutton" and "tributton" 
#  included in the "moreButtons-1.0"-package.
#
#  studbutton is a button that can display both bitmaps and multiline
#  text.
#  tributton is a triangular button that can be oriented in any direction
#-----------------------------------------------------------------------------
source $VIM_PATH/mb-bindings.tcl


#-----------------------------------------------------------------------------
#  Load Motif look & feel (colors & bindings)
#  and init the TIX package : 
#-----------------------------------------------------------------------------
lappend auto_path $TIX_PATH/library
source $TIX_PATH/schemes/Gray14.tcl
source $TIX_PATH/bindings/Motif.tcl
tixInit $TIX_PATH/library


#----------------------------------------------------------------------------
#  Don't use strict Motif (i.e. highlight widgets when entering with mouse)
#----------------------------------------------------------------------------
set tk_strictMotif 0


#-----------------------------------------------------------------------------
# global variables
#-----------------------------------------------------------------------------
set state STOPPED	;# state of the ising widget [STOPPED|PLAYING|PAUSED]
set outputFileName {}	;# string that holds the name of the outputfile
set outputDeviceName {} ;# string that holds the name of the output device
set outputDevice 1	;# var for outputDevice (1 = printer; 0 = file)
set colorOption 0	;# 0 = b&w; 1 = color
set resolution 1	;# var for size radiobuttons
set beta1 1.333334	;# model parameters
set beta2 -30.0
set beta3 -30.0
set beta4 0.0
set beta5 0.0
set sublat 2		;# number of sub-lattices to show
set color "SGIgrey80"
set drawX 0		;# x position of the drawing window
#-----------------------------------------------------------------------------
# procedures:
#-----------------------------------------------------------------------------


#-----------------------------------------------------------------------------
# mkMainWindow w
#
# Build the main window of the GUI
#
# Arguments:
#	w -	window
#-----------------------------------------------------------------------------
proc mkMainWindow {w} {

	# hide toplevel window
	wm withdraw .


	toplevel $w
	wm title $w "VIM \[Control Panel\]" 
	wm minsize $w 100 100
	wm iconname $w "Control"

	wm protocol $w WM_DELETE_WINDOW "mkQuit" 

	mkMainMenu $w
	mkControlPanel $w
#	mkScrollPanel $w


}


#-----------------------------------------------------------------------------
# mkMainMenu w
#
# Build the main menu
#
# Arguments:
#	w -	window
#-----------------------------------------------------------------------------
proc mkMainMenu {w} {

	global resolution
	
	set menuF $w.menu

	frame $menuF -relief raised -bd 2

	menubutton $menuF.file \
	        -text "File"  \
	        -underline 0 \
		-menu $menuF.file.m 

	menu $menuF.file.m
	$menuF.file.m add command -label "Print..." \
	        -underline 0 \
 		-command "mkPrint $w.printdlg"
	$menuF.file.m add separator
	$menuF.file.m add command -label "Quit" \
	        -underline 0 \
 		-command "quitVIM"

	menubutton $menuF.options \
	        -text "Options"  \
    	    -underline 0 \
		-menu $menuF.options.m  

	menu $menuF.options.m
	$menuF.options.m add command -label "Parameters..." \
	        -underline 0 \
		-command "mkParam"
	$menuF.options.m add command -label "Size..." \
	        -underline 0 \
		-command "mkSize $w.sizedlg"

	pack $menuF.file $menuF.options -side left

	tk_menuBar $menuF $menuF.file $menuF.options

	pack $menuF -side top -fill x
	focus default $menuF

}

#-----------------------------------------------------------------------------
# mkScrollPanel w
#
# Build a panel for scrolling the ising widget
#
# Arguments:
#	w -	toplevel window
#-----------------------------------------------------------------------------
proc mkScrollPanel {w} {
	global BITMAP_PATH
	
	set spLabelF [tixLabelFrame $w.spLabelF -label Scroll]
	
	set sF  [frame $spLabelF.spScrollsF]
	set udF [frame $sF.spUpDownF]
	set lrF [frame $sF.spLeftRightF]
	set rF  [frame $sF.spResetF]
	
	# build the scroll buttons
	tributton $w.spUpB \
		-relief groove -bd 2 \
		-direction n \
		-length 40 \
		-anchor c \
		-bg red -activebackground red3 \
		-fg blue -activeforeground pink  
	tributton $w.spDownB \
		-relief groove -bd 2 \
		-direction s \
		-length 40 \
		-anchor c\
		-bg red -activebackground red3 
	tributton $w.spLeftB \
		-relief groove -bd 2 \
		-direction w \
		-length 40 \
		-anchor c\
		-bg red -activebackground red3
	tributton $w.spRightB \
		-relief groove -bd 2 \
		-direction e \
		-length 40 \
		-anchor c\
		-bg red -activebackground red3
	button $w.spResetB \
		-relief groove -bd 2 \
		-bitmap @$BITMAP_PATH/resetscroll.xbm \
		-fg red -activeforeground red3
		
	pack $w.spLabelF \
		-expand yes -fill both -padx 20 -pady 20

	pack $sF \
		-expand yes -fill both

	pack $udF $lrF $rF \
		-side left -expand yes -fill both

	pack $w.spUpB $w.spDownB -in $udF \
		-expand yes -fill both 
	pack $w.spLeftB $w.spRightB -in $lrF \
		-side left -expand yes -fill both
	pack $w.spResetB -in $rF \
		-expand yes -fill both
		
 
}



#-----------------------------------------------------------------------------
# mkControlPanel w
#
# Build a panel for controlling the ising widget
#
# Arguments:
#	w -	toplevel window
#-----------------------------------------------------------------------------
proc mkControlPanel {w} {
	global BITMAP_PATH
	
	set cpLabelF [tixLabelFrame $w.cpLabelF -label Controls]
	
	frame $w.cpControlsF
	frame $w.cpTopF
	frame $w.cpBotF
	
	# build the control buttons
	button $w.cpPlayPauseB \
		-relief groove -bd 2 \
		-bitmap @$BITMAP_PATH/playpause.xbm
	button $w.cpStopB \
		-relief groove -bd 2 \
		-bitmap @$BITMAP_PATH/fillstop.xbm
	button $w.cpLeftB \
		-relief groove -bd 2 \
		-bitmap @$BITMAP_PATH/back.xbm -state disabled
	button $w.cpRightB \
		-relief groove -bd 2 \
		-bitmap @$BITMAP_PATH/forward.xbm -state disabled
	
	$w.cpPlayPauseB configure -command "remote {playPause}"
	$w.cpStopB configure \
		-command { set scrollx 0
			   set scrolly 0 
			   remote "stop" 
			 }
	$w.cpRightB configure -command "remote {stepForw}"


	pack $w.cpLabelF \
		-side bottom -expand yes -fill both -padx 20 -pady 20
	pack $w.cpControlsF -in $cpLabelF \
		-expand yes -fill both
	pack $w.cpTopF -in $w.cpControlsF \
		-side top -expand yes -fill both
	pack $w.cpBotF -in $w.cpControlsF \
		-side bottom -expand yes -fill both
	
	pack $w.cpPlayPauseB $w.cpStopB -in $w.cpTopF \
		-side left -expand yes -fill both \
		-ipadx 30
		
	pack $w.cpLeftB $w.cpRightB -in $w.cpBotF \
		-side left -expand yes -fill both \
		-ipadx 30
 
}


#-----------------------------------------------------------------------------
# quitVIM
#
# close all windows of both applications and exit afterwards
#-----------------------------------------------------------------------------
proc quitVIM {} {
	remote {after 1 exit}
	exit
}



#-----------------------------------------------------------------------------
# main
#-----------------------------------------------------------------------------

mkMainWindow $MAIN	;# build the main window
prApply			;# apply parameters
