'\"
'\" Copyright (c) 1992 The Regents of the University of California.
'\" All rights reserved.
'\"
'\" Permission is hereby granted, without written agreement and without
'\" license or royalty fees, to use, copy, modify, and distribute this
'\" documentation for any purpose, provided that the above copyright
'\" notice and the following two paragraphs appear in all copies.
'\"
'\" IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY
'\" FOR DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
'\" ARISING OUT OF THE USE OF THIS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
'\" CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
'\"
'\" THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
'\" INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
'\" AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
'\" ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
'\" PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
'\" 
'\" $Header: /user6/ouster/wish/man/RCS/canvas.n,v 1.19 93/08/06 11:11:03 ouster Exp $ SPRITE (Berkeley)
'/"
.so man.macros
.HS layout tk
.BS
'\" Note:  do not modify the .SH NAME line immediately below!
.SH NAME
layout \- Perform graph layout on canvas widgets
.SH SYNOPSIS
\fIpathName \fB graph \fR?\fIoptions\fR?
.SH "STANDARD OPTIONS"
.LP
.nf
.ta 4c 8c 12c
\fBadd\fR	\fBclear\fR	\fBconfigure\fR	\fBdestroy\fR
\fBedges\fR	\fBlayout\fR	\fBnodes\fR	\fBremove\fR
.fi
.LP
.BE

.SH INTRODUCTION
.PP
The Tk \fIcanvas\fR window type has been augmented
to allow graph layout of the selected canvas items.
It operates by associating extra graph information
with the canvas.  Items are created
using the normal canvas operations.
Any existing item may, by a separate command to the canvas,
be added to or removed from the list of items layed-out by the graph.
.PP
Four styles of layout are currently supported: ISI, Tree, Random, and Matrix.
Some simple experiments will demonstrate the differences.
.PP
A new type of item, Edge (taken from tkIcon)
is provided as the means of laying edges between nodes.
Non-edge canvas items are treated as nodes, but
not all canvas item types can be handled by the graph layout code.
Currently it will handle
ovals, polygons, bitmaps, rectangles, textitems, and widgets (windows),
as nodes of the graph.

.SH "WIDGET COMMAND"
.PP
The Tk \fIcanvas\fR widget has been augmented with a one new command,
namely \fBgraph\fR.
This command may be used to invoke various
graph related operations on the canvas.
It has the following general form:
.DS C
\fIpathName \fBgraph \fIoption \fR?\fIarg arg ...\fR?
.DE
\fIOption\fR and the \fIarg\fRs
determine the exact behavior of the command.
The following options are possible:
.TP
\fIpathName \fBgraph add \fItagOrId\fR ?\fItagOrId tagOrId ...\fR?
Notifies the canvas that the specified items are to be
added to the graph attached to the canvas.
The position on the canvas of these items will subsequently
be altered by the \fBlayout\fR command.
.TP
\fIpathName \fBgraph clear \fR
Removes all edges and nodes from association with the graph.
.TP
\fIpathName \fBgraph configure ?\fIoption\fR? ?\fIvalue\fR? ?\fIoption value ...\fR?
Query or modify the configuration options of the graph associated
with the widget.
If no \fIoption\fR is specified, returns a list describing all of
the available options for graph of \fIpathName\fR
If \fIoption\fR is specified
with no \fIvalue\fR, then the command returns a list describing the
one named option (this list will be identical to the corresponding
sublist of the value returned if no \fIoption\fR is specified).  If
one or more \fIoption\-value\fR pairs are specified, then the command
modifies the given option(s) to have the given value(s);  in
this case the command returns an empty string.
Possible options are:
.DS
.IP "\fB-computenodesize \fIboolean \fR"
(Matrix) Decide to precompute max node size.
.IP "\fB-elementsperline \fIinteger \fR"
(Matrix) Number of elements per line.
.IP "\fB-hideedges \fIboolean \fR"
(Matrix) Make all edges have zero length to get them out of the
way; otherwise, they clutter the matrix layout.
.IP "\fB-keeprandompositions \fIboolean \fR"
(Random) The value ``true'' means that
nodes are only placed randomly, when their current position
is invalid. An invalid position is the coordinate -1, -1.
.IP "\fB-nodespaceh \fIdistance \fR"
Specifies the additional horizontal offset between the nodes.
.IP "\fB-nodespacev \fIdistance \fR"
Specifies the additional vertical offset between the nodes.
.IP "\fB-maxx \fIdistance \fR"
Give the maximum x position for randomly placed nodes.
.IP "\fB-maxy \fIdistance \fR"
Give the maximum y position for randomly placed nodes.
.IP "\fB-order \fIinteger\fR"
The value 1 means layout top down, 0 means layout left to right.
.IP "\fB-root \fItagOrId\fR"
Specify the node to use as the root of the graph.
.IP "\fB-xoffset \fIdistance \fR"
Specify an x offset for the placed graph.
.IP "\fB-yoffset \fIdistance \fR"
Specify a y offset for the placed graph.
.\".IP \fB-graphname \fIname\fR
.\"Attaches a name for the graph; currently unused.
.\".IP "\fB-edgeheight \fIinteger\fR"
.\"Specify the height of all edges.
.\".IP "\fB-edgewidth \fIinteger\fR"
.\"Specify the width of all edges.
.DE
.TP
\fIpathName \fBgraph destroy \fR
Clears the graph and then removes the graph from
the canvas.
.TP
\fIpathName \fBgraph edges \fR
Returns the canvas ids of all the edges associated with the graph.
.TP
\fIpathName \fBgraph layout\fR ?\fIcommand\fR
This command implements certain layout mechanisms over
the items in the graph attached to the canvas.
The parameter \fIcommand\fR
specifies what should be layed-out.
If not specified \fIcommand\fR defaults to \fBisi\fR.
.DS
.IP \fBisi\fR
layouts a tree graph with the ISI algorithm.
.IP \fBtree\fR
layouts a tree graph in the form of a tree.
.IP \fBmatrix\fR
arranges all node items in a simple matrix.
Note that this layout is best if no edges are specified.
.IP \fBrandom\fR
assigns random positions to all nodes.
.DE
.TP
\fIpathName \fBgraph nodes\fR
Returns the canvas ids of all the nodes associated with the graph.
.TP
\fIpathName \fBgraph remove \fItagOrId\fR ?\fItagOrId tagOrId ...\fR?
Notifies the canvas that the specified items are to be
removed from the graph attached to the canvas.
The position on the canvas of these items will not subsequently
be altered by the \fBlayout\fR command.
Note that removal from the graph does \fBnot\fI imply
removal from the canvas.

.SH "EDGE ITEMS"
.PP
Items of type \fBedge\fR appear on the display as lines with
a label in the middle. Edges are created with canvas widget
commands of the following form:
.DS
\fIpathName \fBcreate edge \fIx1 y1... xn yn \fR?\fIoption value option value ...\fR?
.DE
The arguments \fIx1\fR through \fIyn\fR give
the coordinates for a series of two or more points that describe
a series of connected line segments.
After the coordinates there may be any number of \fIoption\fR-\fIvalue\fR
pairs, each of which sets one of the configuration options
for the item.  These same \fIoption\fR\-\fIvalue\fR pairs may be
used in \fBitemconfigure\fR widget commands to change the item's
configuration. The standard Line options are supported.
Additionally the following options are supported for edges:
.TP
\fB\-background \fIcolor\fR
Draw the background of the label with \fIcolor\fR, which may be
specified in any of the forms accepted by \fBTk_GetColor\fR.
.TP
\fB\-font \fIfontName\fR
Specifies the font to be used for the label.
\fIFontName\fR may be any string acceptable to \fBTk_GetFontStruct\fR.
If this option isn't specified, it defaults to a system-dependent
font.
.TP
\fB\-from \fInodeId\fR
Specifies the node id where the edge starts.
.TP
\fB\-graphname \fIname\fR
Specifies the name of the graph that contains this edge. An
edge can only be member of one graph at the same time.
.TP
\fB\-label \fItext\fR
Specifies the text to be displayed in the label.
.TP
\fB\-menu1 \fImenuName\fR
Specifies the name of a menu that should be attached to the
edge (usually mouse button 3).
.TP
\fB\-menu2 \fImenuName\fR
Specifies the name of a menu that should be attached to the
edge (usually meta mouse button 3).
.TP
\fB\-menu3 \fImenuName\fR
Specifies the name of a menu that should be attached to the
edge (usually control mouse button 3).
.TP
\fB\-name \fIedgeName\fR
Specifies the name of the edge.
.TP
\fB\-state \fIstate\fR
Specifies the state of the edge. Possible values are
\fIselected\fR and \fInormal\fR.
.TP
\fB\-to \fInodeId\fR
Specifies the node id where the edge ends.

.SH NOTES
.PP
The layout routine assigns coordinates to the upper left
corner of node bounding boxes.  If the node is a canvas widget item
or a text item and no anchor was specified,
then this will not position correctly.
Therefore, when creating widget or text nodes,
one should specify \fB-anchor nw\fR
in order for positioning to be correct.

.SH ACKNOWLEDGEMENTS
.PP
This capability was taken directly from the tkMegaWidget and tkIcon
system of of Sven Delmas (garfield@cs.tu-berlin.de) of the Tech. Univ. Berlin.
This system was constructed because the original tkIcon+tkMegaWidget system,
while nice and useful, was far to heavy weight.
This re-packaging sacrifices some features for simpler insertion
into Tk.

.SH KEYWORDS
canvas, widget, edge, node, layout, tree
