#
# MX routines to interface to the MH mail reader (exmh)
#

# Create an MH menu

proc MhInit {} {
    mxMenu MH
    mxMenuAdd MH "What is this?" { MhHelp }
    mxMenuAddSeparator MH
    catch { MhMenuSignatureEntries MH }
    mxMenuAdd MH "Start Exmh" 	{ exec exmh & }
    mxMenuAdd MH "Send Draft" 	{ MhEditDone }
    mxMenuAddSeparator MH
    mxMenuAdd MH "Abort Draft"	{ MhEditAbort }

    mxMenuBind <Control-Return> MH "Send Draft"
}

proc MhHelp {} {
    mxDialog .mhhelp "MH Info" {
This menu is used to interact with a front end
to the MH mail system.  The front end is a wish
script called exmh, which is available via ftp:
parcftp.xerox.com:/pub/exmh/exmh-*.tar.Z
}
}

proc MhMenuSignatureEntries { menuname } {
    set addsep 0
    foreach file [glob ~/.signature*] {
	set addsep 1
	set entryName [file tail $file]
	mxMenuAdd $menuname $entryName "MhSignature $file"
    }
    if { $addsep } {
	mxMenuAddSeparator $menuname
    }
}
proc MhSignature { file } {
    if [file exists $file] {
	mxCaret eof ; mxSee caret
	mxRead $file
    } else {
	mxFeedback "No $file file"
    }
}

proc MhSendIt { rmtcmd } {
    global MhInterpreter
    # Make sure the file is written out
    if [catch {mxWritten allWindows} ] {
	mxSave
    }
    # Send the list rmtcmd to the exmh interpreter
    if ![info exists MhInterpreter] {
	set MhInterpreter exmh
    }
    if [catch {send $MhInterpreter {info library}}] {
	foreach num {2 3 4 5 6 7 8 9} {
	    set MhInterpreter "[lindex $MhInterpreter 0] #$num"
	    if [catch {send $MhInterpreter {info library}} err] {
		continue
	    } else {
		break
	    }
	}
    }
    mxFeedback "Sending \"$rmtcmd\" to $MhInterpreter..."
    if [catch {
	send $MhInterpreter $rmtcmd
    } err] {
	case $err {
	    {{remote interpreter did not respond}} {
		mxFeedback "Please check exmh window for status"
	    }
	    default {
		mxFeedback "Send error: $err"
		set MhInterpreter exmh
	    }
	}
    } else {
	mxFeedback "ok"
    }
}
proc MhEditDone {} {
    # Done editing this message draft
    global mxFile
    MhSendIt [list Edit_Done send [file tail $mxFile]]
}
proc MhEditAbort {} {
    # Abort this message draft
    global mxFile
    MhSendIt [list Edit_Done abort [file tail $mxFile]]
}
