use strict;
use warnings;

use SQL::Steno;

use Test::More tests => 1;



# Fake DBI
my $sth = bless {
   Active => 1,
   NAME => ["a\nz", "b\tc", "d'e", 'b"c', 'x,y', 'f:g', 'Verrrrrrrry long name indeed', 'a_col']
}, 'DBI::st';

my @rows;

sub DBI::st::execute {
    @rows = ([1..6,'1999-12-31 23:59:59',undef],['shift', @{$sth->{NAME}}],[11..17,'1970-01-01 00:00:00']);
}

sub DBI::st::fetchrow_array {
     @rows ? @{shift @rows} : ();
}



sub test($$;$$) {
    $sth->execute;
    open my $fh, '>', \my $str;
    my $ofh = select $fh;
    eval { no strict 'refs'; &{"SQL::Steno::render_$_[0]"}( $sth, $_[2], $_[3] ) };
    close $fh;
    select $ofh;
    is $str, $_[1], $_[0];
}

test tabular => <<\OUT;
a\nz |b\tc|d'e |b"c|x,y|f:g|Verrrrrrrry long name indeed
     |    |    |   |   |   |              |a_col                       |
-----|----|----|---|---|---|--------------|----------------------------|
1    |2   |3   |4  |5  |6  |1999-12-31 24:|\@                          |
shift|a\nz|b\tc|d'e|b"c|x,y|f:g           |Verrrrrrrry long name indeed|
11   |12  |13  |14 |15 |16 |17            |1970- 00:                   |
OUT

test csv => <<\OUT;
"a
z",b	c,d'e,"b""c","x,y",f:g,Verrrrrrrry long name indeed,a_col
1,2,3,4,5,6,1999-12-31 23:59:59,
shift,"a
z",b	c,d'e,"b""c","x,y",f:g,Verrrrrrrry long name indeed,a_col
11,12,13,14,15,16,17,1970-01-01 00:00:00
OUT

test yaml => <<\OUT;
- "a\nz":                       1
  b	c:                          2
  "d'e":                        3
  "b\"c":                       4
  "x,y":                        5
  "f:g":                        6
  Verrrrrrrry long name indeed: "1999-12-31 23:59:59"
  a_col:                        ~
- "a\nz":                       shift
  b	c:                          |2-
    az
  "d'e":                        b	c
  "b\"c":                       "d'e"
  "x,y":                        "b\"c"
  "f:g":                        "x,y"
  Verrrrrrrry long name indeed: "f:g"
  a_col:                        Verrrrrrrry long name indeed
a_col
- "a\nz":                       11
  b	c:                          12
  "d'e":                        13
  "b\"c":                       14
  "x,y":                        15
  "f:g":                        16
  Verrrrrrrry long name indeed: 17
  a_col:                        "1970-01-01 00:00:00"
OUT