;;; -*- Package: User -*-
;;;
;;; **********************************************************************
;;; This code was written as part of the CMU Common Lisp project at
;;; Carnegie Mellon University, and has been placed in the public domain.
;;; If you want to use this code or any part of CMU Common Lisp, please contact
;;; Scott Fahlman or slisp-group@cs.cmu.edu.
;;;
(ext:file-comment
  "$Header: comutil.lisp,v 1.2 91/02/08 13:31:33 ram Exp $")
;;;
;;; **********************************************************************
;;;
;;; This is a file loaded into a lisp to compile all the matchmaker interfaces.
;;;
(in-package "USER")

(when (probe-file "icode:lossage.log") (delete-file "icode:lossage.log"))
(mapc #'delete-file (directory "icode:*.fasl"))

(defun com (name)
  (declare (special *alien-eval-when*))
  (with-open-file (f "icode:lossage.log"
		     :direction :output
		     :if-exists :append
		     :if-does-not-exist :create)
    (let ((*standard-output* (make-broadcast-stream *standard-output* f)))
      (let ((*alien-eval-when* '(compile load)))
	(compile-file (concatenate 'string "icode:" name "defs.lisp")
		      :error-file nil))

      (let ((*alien-eval-when* '(eval)))
	(load (concatenate 'string "icode:" name "msgdefs.lisp")))
      
      (let ((*alien-eval-when* '(compile)))
	(compile-file (concatenate 'string "icode:" name "user.lisp")
		      :error-file nil)))))

(setq clc::*alien-fold* t)

(com "mach")
(com "netname")
