-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: preinit.p
-- Author: Rob Strom
-- SCCS Info: @(#)prechecked.p	1.2 1/9/92

PreChecked : USING( tscheck, Predefined  ) PROCESS (PreInitInit : DeterminePreconditionInport )
-- procedure to check precondition INIT
-- Algorithm: Store INIT(X) in the list of required operands
  DECLARE
    FP: DeterminePreconditionCall ;
  BEGIN
    RECEIVE FP FROM PreInitInit ;
    INSERT (EVALUATE InitX: Attribute FROM
      NEW InitX;
      NEW InitX.Objects;
      UNITE InitX.Name.Init FROM EVALUATE Empty: Empty FROM END;
      INSERT FP.Statement.Operands[FP.Affected_Operands[0]] INTO InitX.Objects;
      END) INTO FP.Required;
    INSERT (EVALUATE CheckedX: Attribute FROM
      NEW CheckedX;
      NEW CheckedX.Objects;
      UNITE CheckedX.Name.Checked FROM EVALUATE Empty2: Empty FROM END;
      INSERT Object IN FP.Statement.Operands WHERE(POSITION OF Object = Offset in FP.Affected_Operands WHERE(POSITION OF Offset = 0)) INTO CheckedX.Objects;
      END) INTO FP.Required;
    RETURN FP;
  END PROCESS
