-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: precall.p
-- Author: Rob Strom
-- SCCS Info: @(#)precall.p	1.1 7/27/89

PreCall : USING( tscheck, Predefined  ) PROCESS (PreCallInit : DeterminePreconditionInport )
-- procedure to set the preconditions of a call
-- algorithm:  
-- 1. Determine the callport's type
-- 2. Determine the bound inport's type
-- 3. Determine the callmessage type
-- 4. Require the callport itself to be INIT.
-- 5. For each modifiable parameter, require the typestate in which
--    the actual parameters are substituted for the formal.  Forbid any
--    other attributes of the current TS which include the actual or
--    any subcomponent of the actual. ( CASE(V, V.A) does not "include" V.A)
--    Require the modifiable parameter to be VAR.
-- 6. For each non-modifiable parameter, require the typestate in which
--    the actual parameters are substituted for the formal.  Don't forbid anything.
  DECLARE
    FP: DeterminePreconditionCall ;
    CallportObject: ObjectName; -- the callport
    CallportType: TypeName; -- type of the callport
    RequiredTypestate: Typestate; -- of the actual parameter
    Nothing: Empty; -- what optional fields are
    FormalTS: Formal_Typestate; -- minimum TS + inport message TS
  BEGIN
    RECEIVE FP FROM PreCallInit ;
    -- 1.
    CallportObject <- ObjectName # (Operand IN FP.Statement.Operands WHERE(boolean # (integer # (POSITION OF Operand) = integer # (0))));
    CallportType <- TypeName # (FP.Services.TypeOf(FP.Services, FP.Declarations, FP.Definitions, FP.Context, CallportObject));
    -- 2.
    INSPECT CPModule IN FP.Definitions WHERE(boolean # (CPModule.Id = CallportType.ModuleId))
      BEGIN
        INSPECT CPDefinition IN CPModule.Type_Definitions WHERE(boolean # (CPDefinition.Id = CallportType.TypeId))
          BEGIN
            REVEAL CPDefinition.Specification.Outport_info;
            -- 3.
            INSPECT IPModule IN FP.Definitions WHERE(boolean # (IPModule.Id = CPDefinition.Specification.Outport_info.ModuleId))
              BEGIN
                INSPECT IPDefinition IN IPModule.Type_Definitions WHERE(boolean # (IPDefinition.Id = CPDefinition.Specification.Outport_info.TypeId))
                  BEGIN
                    REVEAL IPDefinition.Specification.Inport_info;
                    INSPECT CMModule IN FP.Definitions WHERE(boolean # (CMModule.Id = IPDefinition.Specification.Inport_info.Message_type.ModuleId))
                      BEGIN
                        INSPECT CMDefinition IN CMModule.Type_definitions WHERE(boolean # (CMDefinition.Id = IPDefinition.Specification.Inport_info.Message_type.TypeId))
                          BEGIN
                            REVEAL CMDefinition.Specification.Callmessage_Info;
                            -- 4, 5.
                            INSPECT Minimum IN CMDefinition.Specification.Callmessage_Info.Exception_Specifications[CMDefinition.Specification.Callmessage_info.Minimum]
                              BEGIN
                                -- MERGE with union
                                FormalTS := Minimum.Post_Typestate;
                                FOR Attr IN IPDefinition.Specification.Inport_info.Message_Typestate[]
                                  INSPECT
                                    BLOCK 
                                      BEGIN
                                        INSERT COPY OF Attr INTO FormalTS;
                                      ON (DuplicateKey)
                                      END BLOCK;
                                  END FOR;
                              END INSPECT;
                            RequiredTypestate <- Typestate # (FP.Services.SubstituteCallParameters(FP.Services, FP.Statement.Operands, CMDefinition.Component_Declarations, FormalTS));
                            FOR Operand IN FP.Statement.Operands WHERE(boolean # 'true')
                              INSPECT
                                IF boolean # (integer # (POSITION OF Operand) = integer # (0))
                                  THEN
                                    -- 4.
                                    BLOCK
                                      BEGIN
                                        INSERT (EVALUATE InitX: Attribute FROM
                                          NEW InitX;
                                          New InitX.Objects;
                                          UNITE InitX.Name.Init FROM EVALUATE Empty: Empty FROM END;
                                          INSERT Objectname # (COPY OF Operand) INTO InitX.Objects;
                                        END) INTO FP.Required;
                                      ON (DuplicateKey)
                                      END BLOCK;
                                  ELSE
                                    INSPECT CMComponent IN CMDefinition.Component_Declarations WHERE(boolean # (integer # (POSITION OF CMComponent) = integer # (integer # (POSITION OF Operand) - integer # (1))))
                                      BEGIN
                                        IF boolean # (EXISTS OF Constant IN CMDefinition.Specification.Callmessage_Info.Constants WHERE(boolean # (Constant = CMComponent.Id)))
                                          THEN
                                          ELSE
                                            MERGE FP.Services.Involving(FP.CurrentTS, Operand, RequiredTypestate) INTO FP.Forbidden;
                                            CALL FP.Services.CheckVar(FP.Services, FP.Definitions, FP.Declarations, FP.Context, Operand, FP.Position);
--                                          MERGE Attributes # (EVERY OF TSAttribute IN FP.CurrentTS WHERE(boolean # (boolean # (EXISTS OF Object IN TSAttribute.Objects WHERE(boolean # (Object = Operand))) AND boolean # (NOT boolean # (EXISTS OF Attribute IN RequiredTypestate WHERE(boolean # (TSAttribute = Attribute))))))) INTO FP.Forbidden; -- EVERY OF not supported yet
--                                             FOR TSAttribute IN FP.CurrentTS WHERE(boolean # (boolean # (EXISTS OF Object IN TSAttribute.Objects WHERE(boolean # (Object = Operand))) AND boolean # (NOT boolean # (EXISTS OF Attribute IN RequiredTypestate WHERE(boolean # (TSAttribute = Attribute))))))
--                                               INSPECT
--                                                 INSERT Attribute # (COPY OF TSAttribute) INTO FP.Forbidden;
--                                               END FOR;
                                          END IF;
                                      END INSPECT;
                                  END IF;
                              END FOR;
                          END INSPECT; 
                      END INSPECT;
                  END INSPECT;
              END INSPECT;
          END INSPECT;
      END INSPECT;
    FOR Attribute IN RequiredTypestate WHERE(boolean # 'true')
      INSPECT
        BLOCK
          BEGIN
            INSERT Attribute # (COPY OF Attribute) INTO FP.Required;
          ON (DuplicateKey)
          END BLOCK;
      END FOR;
    RETURN FP;
  ON (Others)
    PRINT charstring # "trouble in precall";
  END PROCESS
