-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS info: @(#)messagetypeof.p	1.3 3/13/90 

-- The function MessageTypeOf is a type inference function called by Infer
-- returns the message type of its argument which must be an outport
-- or an inport 

messagetypeof: using(type,checking_table, stdenv)
PROCESS(InferQ: InferRuleQueue)
DECLARE
  InferM: InferRuleMessage;

BEGIN
  RECEIVE InferM FROM InferQ;
  INSPECT definitions_module IN InferM.definitions 
    	WHERE(boolean#(definitions_module.id = InferM.argument.moduleid))
  BEGIN
    INSPECT type_def IN definitions_module.type_definitions
	  WHERE(boolean#(type_def.id = InferM.argument.typeid))
    BEGIN
      SELECT primitive_types#(CASE OF type_def.specification)
      WHERE(primitive_types#'inporttype')
	REVEAL type_def.specification.inport_info;
	InferM.result := type_def.specification.inport_info.message_type;
      WHERE(primitive_types#'outporttype') 
	REVEAL type_def.specification.outport_info;
	INSPECT def_module IN InferM.definitions 
	      WHERE(boolean#(def_module.id = 
		  type_def.specification.outport_info.moduleid))
	BEGIN
	  INSPECT t_def IN def_module.type_definitions
		WHERE(boolean#(t_def.id = 
		    type_def.specification.outport_info.typeid))
	  BEGIN  -- t_def is the definition for the inporttype of type_def
	    IF boolean#(primitive_types#(case of t_def.specification) <>
		    primitive_types#'inporttype') then
	      -- outport not associated with an inport?
	      return InferM exception wrongArgType;
	      exit end_of_func;
	    else
	      REVEAL t_def.specification.inport_info;
	      InferM.result := t_def.specification.inport_info.message_type;
	    end if;
	  END INSPECT;
	END INSPECT;
      OTHERWISE 
	-- arg is neither an inport nor an outport
	RETURN InferM EXCEPTION wrongArgType; 
	EXIT end_of_func;
      END SELECT;
      RETURN InferM;
    END INSPECT;
  END INSPECT;
ON EXIT (end_of_func)  -- do nothing, just exit func
END process

