-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS info: @(#)findtype.p	1.2 3/13/90 

--------------------------------------------------------------------------
-------------------- FIND TYPE OF OBJECTNAME PROCESS ---------------------
--------------------------------------------------------------------------
-- The following function is given an object (of type objectname) and 
-- returns the type of the object.  If the type is not known, then it 
-- raises the exception unknown_type. 
findtype: using(predefined,type,inferredtype)
	process(findTypePort: findTypeQueue)
DECLARE
    findTypeCall: findTypeMessage;
    root_type: optional_typename;
    object_type: typename;
    type_inference: InferredDefinition;
BEGIN
    RECEIVE findTypeCall FROM findTypePort;
    INSPECT scope IN findTypeCall.scopes 
    	WHERE(boolean#(scope.id = findTypeCall.object.root.scope))
    BEGIN
 	INSPECT declaration IN scope.declarations 
            WHERE(boolean#(declaration.id = findTypeCall.object.root.root))
    	BEGIN
    	    root_type := declaration.typename;
        END INSPECT;
    END INSPECT;

-- if the root type is not known, see if it has already been inferred
    IF boolean#(typename_option#(CASE OF root_type) = typename_option#('unnamed'))
    THEN 
        BLOCK 
        BEGIN
      	type_inference := InferredDefinition#(inf IN findTypeCall.inferred
    	    WHERE(boolean#(inf.root = findTypeCall.object.root)));
        UNITE root_type.typename FROM type_inference.type;
        ON (NotFound) -- if not found then the object's type is still unknown
-- so raise the unknown_type exception
    	    RETURN findTypeCall EXCEPTION unknown_type;
    	    EXIT end_point;
    	END BLOCK;
    END IF;

-- if control reaches this point, then root_type is in case 'named'
    REVEAL root_type.typename;
    DISSOLVE root_type.typename INTO object_type;
-- now find the type of the object (we only have the type of root object so far)

    FOR comp IN findTypeCall.object.components WHERE(boolean#'true')
    INSPECT
   	INSPECT defs_module IN findTypeCall.definitions
    	    WHERE(boolean#(defs_module.id = object_type.moduleid))
    	BEGIN
            INSPECT def IN defs_module.type_definitions
       	    	WHERE(boolean#(def.id = object_type.typeid))
    	    BEGIN
    	    	INSPECT component IN def.component_declarations
    	    	    WHERE(boolean#(component.id = comp))
    	    	BEGIN
    	    	    object_type := component.type;
      	    	END INSPECT;    	        	 
     	    END INSPECT;    	        	 
    	END INSPECT;    	        	   	    
    END FOR;

    findTypeCall.object_type <- object_type;
    RETURN findTypeCall;
ON EXIT (end_point)  -- do nothing, just exit process
END process
