-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: profsum.p
-- Author: David Bacon
-- SCCS Info: @(#)profsum.p	1.3 3/11/91

profsum: using (profile, main, common, string, objectIO)
linking(itoa, justify)
   
process (q: mainQ)
    
declare
  args: main;
  argv: charstringList;
  junk: charstring;
  proffile: charstring;
  profiles: profiles;
  operations: integer;
  total: integer;
  itoa: int2stringFn;
  justify: justifyFn;
  pathReadObj: readobject_func;  
begin
  itoa := procedure of process itoa;
  justify := procedure of process justify;
    
  receive args from q;
  argv := args.argv;
  remove junk from argv[0];
  remove junk from argv[0];
  block begin
    remove proffile from argv[0];
  on (NotFound)
    proffile := "hprof";
  end block;
  unwrap pathReadObj from args.rm.get("pathReadObj", "") {init};
  total := 0;
  unwrap profiles from pathReadObj(proffile) { init };

  for profile in profiles[] inspect
    operations := 0;
    for count in profile.counts[] inspect
      operations := operations + count;
    end for;
    
    total := total + operations;
	
    call args.terminal.putString(justify(profile.name, -32));
    call args.terminal.putString(justify(itoa(profile.creates), 8));
    call args.terminal.putLine(justify(itoa(operations), 8));
  end for;
    
  call args.terminal.putLine(justify("--------", 48));
  call args.terminal.putLine(justify(itoa(total), 48));
    
  return args;
end process
   
