-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: stdin2string.p
-- Author: Andy Lowry
-- SCCS Info: @(#)stdin2string.p	1.3 3/11/91

-- Reads lines from stdin and writes them to a string pipe named
-- stdout

stdin2string: using (main, stdio, stringpipe, terminalIO)

process (Q: mainQ)
  
declare
  args: main;
  stdin: stdin;
  stdout: stringPort;
begin
  receive args from Q;
  
  -- collect our pipe ends
  unwrap stdin from args.rm.get("stdin", "stdio") {init, init(getString)};
  unwrap stdout from args.rm.get("stdout", "string") {init};
  
  while 'true' repeat
    send stdin.getString() to stdout;
  end while;
  
on (getStringIntf.endOfInput)
  
end process
