-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: initloadfuncs.d
-- Author: Daniel Yellin
-- SCCS Info: "@(#)initloadfuncs.d	1.4 1/20/92"
-- description:
-- initFindfileFuncs is given some capabilities and returns 5 functions.
-- The first four funcs are findfile functions -- they locate a return a file
-- relative to a unix path
initloadfuncs: using(unix,root,load,cwd,findfile)
definitions 

initloadfuncsIntf: callmessage(
  access: fileAccessFn,
  getcwd: cwd!getCwdFn,
  pathload: load!load_func,
  environ: root!environ,  
  findfilePO: findfile!findfile_func,
  findfileDO: findfile!findfile_func,
  findfilePsrc: findfile!findfile_func,
  findfileDsrc: findfile!findfile_func,
  findfileTarget: findfile!findfile_func
) constant(access, getcwd, pathload, environ)
  exit {full};

initloadfuncsQ: inport of initloadfuncsIntf
    {init(access), init(getcwd), init(pathload), init(environ)};
initloadfuncsFn: outport of initloadfuncsQ;

end definitions
