-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: getdep.d
-- Author: Daniel Yellin
-- SCCS Info: "@(#)getdep.d	1.3 3/11/91"

getdep: using(predefined,common,terminalio,rmanager,findfile,make)
definitions

  actionType: enumeration('print', 'compile');

  ActionInitIntf: callmessage (
    rm: rManager,		-- for invoking action via main interface
    terminal: terminalFunctions,-- ditto
    name: charstring,		-- name of node to be made
    action: make!ActionFunc	-- the action to make this node
  ) constant(rm,terminal,name)
  exit { full };
  ActionInitQ: inport of ActionInitIntf {full(rm),full(terminal),full(name)};
  ActionInitFn: outport of ActionInitQ;

  -- setupGetDepFunc returns the getDependency function (see make.d). 
  setupGetDepIntf: callmessage (
    rm: rManager,
    terminal: terminalFunctions,
    actionType: actionType,
    getdepFunc: GetDependenciesFunc
  ) constant (rm,terminal,actionType)
  exit { full };   
  setupGetDepQ: inport of setupGetDepIntf {full(rm),full(terminal),
    full(actionType)};
  setupGetDepService: outport of setupGetDepQ;

  setupActionIntf: callmessage(
    rm: rManager,
    terminal: terminalFunctions,
    ActionFunc: ActionFunc
  ) constant(rm, terminal)
  exit {full};
  setupActionQueue: inport of setupActionIntf {full(rm),full(terminal)};
  setupActionProcess: outport of setupActionQueue;

end definitions
