/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: hpaths.c */
/* Author: Andy Lowry */
/* SCCS Info: @(#)hpaths.c	1.7 1/29/92 */

/* Routines to determine and return paths for the hermes system root */
/* and binaries directories */

#include "li.h"
#include "storage.h"
#include <pwd.h>

/* If HROOTDIR environment variable is set, use it.  Otherwise, set */
/* HROOTDIR according to the home directory for user 'hermes' and */
/* proceed as usual.  If there's no such user, we fail */

char *
hrootdir()
{
    static char *root = nil;

    char *getenv();

    char *envroot;
    struct passwd *pwent;


    if (root isnt nil)
      return(root);

    if ((envroot = getenv("HROOTDIR")) is nil) {
	if ((pwent = getpwnam("hermes")) is nil) {
	    nilerror("hrootdir",
		     "HROOTDIR not in env and no login for 'hermes'");
	    abort_nili("hrootdir_hpaths");
	}
	else			/* got a passwd entry for hermes */
	  envroot = pwent->pw_dir;
    }

    if ((root = (char *) getmain(strlen(envroot)+1)) is nil) {
	nilerror("hrootdir", "unable to allocate space for hermes root path");
	abort_nili("hrootdir");
    }
    mark_free(root);
    strcpy(root, envroot);
    return(root);
}


char *
hbindir()
{
  static char *bin = nil;
  char *root;

  if (bin isnt nil)
    return(bin);

  root = hrootdir();
  if ((bin = (char *) getmain(strlen(root)+strlen("/bin")+1)) is nil) {
    nilerror("hbindir", "Unable to allocate space for hermes binary path");
    abort_nili("hbindir");
  }
  mark_free(bin);
  sprintf(bin, "%s/bin", root);
  return(bin);
}

char *
hmbindir()
{
  static char *mbin = nil;
  char *root;
  char *mtype = MTYPESTRING;

  if (mbin isnt nil)
    return(mbin);

  root = hrootdir();
  if ((mbin = (char *) getmain(strlen(root)+strlen("/mbin/")+strlen(mtype)+1))
      is nil) {
    nilerror("hmbindir", 
	     "Unable to allocate space for hermes machine binary path");
    abort_nili("hmbindir");
  }
  mark_free(mbin);
  sprintf(mbin, "%s/mbin/%s", root, mtype);
  return(mbin);
}

char *
hmchbindir()
{
  static char *mchbin = nil;
  char *root;
  char *mtype = MTYPESTRING;

  if (mchbin isnt nil)
    return(mchbin);

  root = hrootdir();
  mchbin = (char *) getmain(strlen(root)+strlen("/mchbin/")+strlen(mtype)+1);
  if (mchbin is nil) {
    nilerror("hmchbindir",
	     "Unable to allocate space for hermes machine object path");
    abort_nili("hmchbindir");
  }
  mark_free(mchbin);
  sprintf(mchbin, "%s/mchbin/%s", root, mtype);
  return(mchbin);
}
