/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: excep.ch */
/* Author: David F. Bacon */
#ifndef lint
static char sccsinfo[] = "@(#)excep.ch	1.19 2/17/92";
#endif

/*
 * excep.ch
 *
 * routines to handle exceptions.
 */

#include "cherm.h"
#include "storage.h"

#include "predefined.cd"
#include "interpform.cd"

#define Finalize(obj) (*(obj)->tsdr->finalize)((obj)->value, F_DISCARD, nil)

extern datarep dr_record, dr_nominal, dr_bottom, dr_enumeration,
  dr_ord_enumeration, dr_table;

flag cherm_flag = FALSE;	/* set if we are not really interpreting */
				/*  but are using C-Hermes. */
predef_exception cherm_excep;	/* where we put the error for C-Hermes. */


hobject(Others, variant);

void
init_errors()
{
    BEGIN_CHERM;

    (void) copy(Others, Bottom);	/* pre-init */
    (void) unite(Others, Bottom, handler_type__others);

    END_CHERM;
}

void
term_errors()
{
  (void) Finalize(Others);
}

void
set_error(proc, errtype, errval)
pcb *proc;
dfd_ord_enumeration errtype;
valcell errval;
{
    void set_obj_to_error();

    set_obj_to_error(& proc->ep.h->data[LASTERROR], errtype, errval);
}

/* this routine sets an object to be the error value passed to it.  it */
/* does this by hand in a very ugly fashion instead of calling unite */
/* because unite allocates storage, which we can't do since we are raising */
/* an exception (which might be Depletion).  hence the ugliness of the code. */
void
set_obj_to_error(obj, errtype, errval)
object *obj;
dfd_ord_enumeration errtype;
valcell errval;
{
    valcell lasterr;
    datarep *drep;


    lasterr = obj->value;

    lasterr.variant->info.variant_case = errtype;
    dcdot(lasterr.variant, VARIANT_COMPONENT) = errval;

    switch (errtype) {
      case handler_type__builtin: { drep = & dr_ord_enumeration; break; }
      case handler_type__user: { drep = & dr_record; break; }
      case handler_type__exit: { drep = & dr_nominal; break; }
      case handler_type__others: { drep = & dr_bottom; break; }
    }

    vdotrep(lasterr, VARIANT_COMPONENT) = drep;
}


void
raise_user(error, proc)
valcell error;
pcb *proc;
{
    void set_trigger_error();
    int raise_exception();


    if (proc->type < CProcess) { /* if this is a regular Hermes process... */
	set_error(proc, handler_type__user, error);
	proc->ip = raise_exception(proc);
    }
    else 
      set_trigger_error(proc, handler_type__user, error);
}



void
raise_exit(error, args)
valcell error;
argblock *args;
{
    void do_raise();
    
    set_error(args->sched->ready, handler_type__exit, error);    
    do_raise(args);
}


/* used only when disconnected exception is raised due to number of */
/* connections on an inport that is being waited on going to zero. */
/* also used by hrpc_return_error() when a remote call gets an exception. */
void
raise_remote_predefined(error, proc)
predef_exception error;
pcb *proc;
{
    valcell errval;

    if (proc->type < CProcess) { /* hermes process */
	errval.ord_enum = (dfd_ord_enumeration) error;
	set_error(proc, handler_type__builtin, errval);
	proc->ip = raise_exception(proc);
    }

    /* if a C process, it detects the error when it wakes up. */
    /* might need to change this if other errors are handled this way. */
}


void 
raise_predefined(error, args)
predef_exception error;
argblock *args;
{
    void do_raise();
    void abort_nili();

    valcell errval;

    
    if (cherm_flag)
      cherm_excep = error;
    else {
	errval.ord_enum = (dfd_ord_enumeration) error;
	if (args->sched->ready->type < CProcess) {
				/* if it's a hermes process, raise the */
				/*  exception normally. */
	    set_error(args->sched->ready, handler_type__builtin, 
		      errval);
	    do_raise(args);
	}
	else {			/* non-hermes, non-Cherm error: shouldn't */
				/*  ever happen. */
	    nilerror("raise_predefined", 
		 "Exception raised outside of CHerm by a non-Hermes process");
	    abort_nili("raise_predefined");
	}
    }
}
  
  

static void
do_raise(args)
argblock *args;
{
    int raise_exception();


    args->nextop = raise_exception(args->sched->ready);
}


int
raise_exception(proc)
pcb *proc;
{
    void abort_nili();
    void showstatus();

    hobject(Brec, record);	/* interpform!block_handler */
    hobject(Handlers, table);	/* interpform!block_handlers */
    objectp Lasterr;		/* predefined!handlername */
    handlr_stack *hstack, *oldstack;
    dotcontainer *ep;
    flag found;
    int nextop;


    BEGIN_CHERM;

    ep = proc->ep.h;
    hstack = ep->info.context->estack;
    Lasterr = & ep->data[LASTERROR];

    Handlers->tsdr = & dr_table;

    found = FALSE;

    while (hstack and not found) {
	if (hstack->handler) {	/* is this an exception frame? */

	    Handlers->value = hstack->frame.handler_set;

	    if (h_lookup(Brec, Handlers, Lasterr, 0) is Normal) {
		nextop = integerval(Brec@block_handler__label);
		found = TRUE;
	    }
	    else 
	      if (obj_case_of(Lasterr) isnt handler_type__exit)
		if (h_lookup(Brec, Handlers, Others, 0) is Normal) {
		    nextop = integerval(Brec@block_handler__label);
		    found = TRUE;
#ifdef DEBUG
		    if (debug_level(15)) {
			nilerror("raise_exception", "Others handler invoked");
			showstatus(proc);
		    }
#endif
		}
	}
	else {			/* an inspect frame */
	  if (hstack->frame.inspect->pos_size > 0)
	    { freemain(hstack->frame.inspect->pos.avl,
		       hstack->frame.inspect->pos_size); }
	  dispose(hstack->frame.inspect, inspect_frame);
	}

	oldstack = hstack;
	hstack = cdr(hstack);
	{ dispose(oldstack, handlr_stack); }
    }

    ep->info.context->estack = hstack;

    if (not found) {		/* unhandled exception?? */

#ifdef DEBUG
	if (debug_level(1))
	  showstatus(proc);
#endif
	nilerror("raise_exception", "No handler for exception");
	abort_nili("raise_exception");
    }

    END_CHERM;

    return(nextop);
}
