-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)translation.d	1.2 3/13/90

translation: USING ( predefined, interpform, inferredtype, load ) 

DEFINITIONS



/* rootid_mappings contains the set of mappings from rootids to offsets */

rootid_mappings: TABLE of rootid_mapping {full} keys (id);

/* every rootid_mapping specifies the offsets corresponding to object
   declarations in a scope */

rootid_mapping: RECORD (
        id: scopeid,
        offset_tbl: rootid_offsets
);

rootid_offsets: TABLE of rootid_offset {full} keys (id);

rootid_offset: RECORD (
        id: rootid,
        typename: typename,     /* a predefined type */
        offset: integer
);


/* compid_mappings is a set of mappings between componentids of the types
   record, variant and callmessage, and their offsets */

compid_mappings: TABLE of compid_mapping {full} keys (name);

/* every compid_mapping specifies the offsets corresponding to
   the componentids of a record or callmessage type */

compid_mapping: RECORD (
        name: typename,
        offset_tbl: compid_offsets
);

compid_offsets: TABLE of compid_offset {full} keys (id);

compid_offset: RECORD (
        id: componentid,
        type: typename,
        offset: integer
);


/* opcode_mappings_1 and opcode_mappings_2 contain the mappings
   from Hermes opcodes to L-I opcodes.  opcode_mappings_1 contains those
   Hermes opcodes that are translated straightforwardly into corresponding
   L-I opcodes.  opcode_mappings_2 contains those opcodes whose translations
   depend on the type families of their operands. */

opcode_mappings_1: TABLE of opcode_mapping_1 {full} keys (hermes_opcode);

opcode_mapping_1: RECORD (
        hermes_opcode: operator,
        li_opcode: interpform!opcode
);

opcode_mappings_2: TABLE of opcode_mapping_2 {full} keys (hermes_opcode, type_family);

opcode_mapping_2: RECORD (
        hermes_opcode: operator,
        type_family: primitive_types,
        li_opcode: interpform!opcode
);


key_pair: RECORD (
    	keypart: component_list,
    	object: objectname
);

key_list: TABLE of key_pair {full};
pos_list: TABLE of integer {init};

/* compute_tree is the callmessage type for procedure
   compute_tree that is used to compute a subtree of a selector of the form
   r.keypart_1 = c1 and r.keypart_2 = c2 and r.keypart_3 = c3... */

compute_tree: CALLMESSAGE (
    	clause: clause,	    /* the clause of the selector */
    	position: integer,   	/* the position of the subtree in clause */
    	r: rootid,  	/* the representative element to be selected */
    	optimizable: boolean,	    /* true if subtree is optimizable */
    	key_list: key_list, 	/* list of pairs (keypart, objectname) */
    	pos_list: pos_list  	/* list of positions where r.keypart_n occurs */
)
CONSTANT (clause, position, r)
EXIT {full};

compute_tree_iport: INPORT of compute_tree
{full(clause), init(position), init(r),
init(key_list), init(pos_list)
};

compute_tree_oport: OUTPORT of compute_tree_iport;

/* typeinfo_of_operand is the callmessage type for procedure
   typeinfo_of_operand that is used to find out the type definition
   and type name of an operand in an absprog statement */

typeinfo_of_operand: CALLMESSAGE (
        absprog: program,
        inferred_defs: InferredDefinitions,
        processid: processid,       /* the current process being translated */
        operand: objectname,
        typedef: type_definition,
        typename: typename
)
CONSTANT (absprog, inferred_defs, processid, operand)
EXIT {full};

typeinfo_of_operand_iport: INPORT of typeinfo_of_operand
{full(absprog), full(inferred_defs), initialized(processid),
 full(operand), initialized(typedef), initialized(typename)
};

typeinfo_of_operand_oport: OUTPORT of typeinfo_of_operand_iport;


/* componentids_offsets is the callmessage type for procedure
   componentids_offsets that is used to translate a componentid list
   into an offset list */

componentids_offsets: CALLMESSAGE (
        absprog: program,
        component_list: component_list,
        compid_mappings: compid_mappings,       /* table of mappings between componentids and offsets */
        currtype: typename,     /* on entrance to the procedure, this is the type name of the root object */
                                /* on exit, it is the type name of the last component */
        offset_list: interpform!operand
)
CONSTANT (component_list, absprog)
EXIT {full};

componentids_offsets_iport: INPORT of componentids_offsets
{full(absprog), full(component_list), initialized(compid_mappings),
 full(currtype), initialized(offset_list)
};

componentids_offsets_oport: OUTPORT of componentids_offsets_iport;

/* procedure_oports contains the output ports of all the procedures */

procedure_oports: RECORD (
        translate_process_oport: translate_process_oport,
        translate_clause_oport: translate_clause_oport,
        componentids_offsets_oport: componentids_offsets_oport,
        typeinfo_of_operand_oport: typeinfo_of_operand_oport
);


/* translate_clause is the callmessage type for procedure
   translate_clause that translate an absprog clause into LI-code */

translate_clause: CALLMESSAGE (
        absprog: program,
        inferred_defs: InferredDefinitions,
        rootid_mappings: rootid_mappings,
        opcode_mappings_1: opcode_mappings_1,
        opcode_mappings_2: opcode_mappings_2,
        processid: processid,
        clauseid: clauseid,         /* clauseid of the clause to be translated */
        procedure_oports: procedure_oports,
        compid_mappings: compid_mappings,
        li_prog: interpform!prog    /* contains the code to which the output
                                       of the translation is added */
)
CONSTANT (absprog, inferred_defs, rootid_mappings, opcode_mappings_1, opcode_mappings_2,
          processid, clauseid, procedure_oports)
EXIT {full};

translate_clause_iport: INPORT of translate_clause
{full(absprog), full(inferred_defs), full(rootid_mappings),
 full(opcode_mappings_1), full(opcode_mappings_2), 
 initialized(processid), initialized(clauseid), full(procedure_oports),
 initialized(compid_mappings), initialized(li_prog)
};

translate_clause_oport: OUTPORT of translate_clause_iport;


/* translate_process is the callmessage type for procedure
   translate_process that translate an absprog process into an LI program */

translate_process: CALLMESSAGE (
        absprog: program,
        inferred_defs: InferredDefinitions,
        opcode_mappings_1: opcode_mappings_1,
        opcode_mappings_2: opcode_mappings_2,
        procedure_oports: procedure_oports,
        processid: processid,       /* id of process to be translated */
        li_prog: interpform!prog        /* the output of the translation */
)
CONSTANT (absprog, inferred_defs, opcode_mappings_1, opcode_mappings_2, 
          procedure_oports, processid)
EXIT {full};

translate_process_iport: INPORT of translate_process
{full(absprog), full(inferred_defs), full(opcode_mappings_1),
 full(opcode_mappings_2), full(procedure_oports),
 initialized(processid)
};

translate_process_oport: OUTPORT of translate_process_iport;


/* translation is the callmessage type for process translation
   the translate an absprog into an LI program */

translation: CALLMESSAGE (
    	absprog: program,
    	inferred_defs: InferredDefinitions,
	load: load!load_func,
    	li_prog: interpform!prog
)
CONSTANT (absprog, inferred_defs, load)
EXIT {full};

translation_iport: INPORT of translation 
	{full(absprog), full(inferred_defs), init(load)};

translation_oport: OUTPORT of translation_iport;


clauseids: ordered table of clauseid { init };

end definitions
