-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)initfindfile.d	1.4 2/4/92

initFindFile: using (findFile, unix, cwd) definitions

  initFindFile: callmessage (
    access: fileAccessFn,
    getCwd: cwd!getCwdFn,
    path: charstring,
    pathfunc: findfile_Func
  ) constant (access, getCwd, path)
    exit { full };

  initFindFileQ: inport of initFindFile
    { init(access), init(getCwd), init(path) };
  initFindFileFn: outport of initFindFileQ;

  -- service interface used internally by findfile...
  normalizePath: callmessage (
    path: charstring,		-- unnormalized path on input
    cwd: charstring,		-- current working directory
    normalized: charstring	-- normalized equivalent
  )
  constant (path, cwd)
  exit {full}
  exception impossible {init(path),init(cwd)};	-- too many .. components
  normalizePathQ: inport of normalizePath {init(path),init(cwd)};
  normalizePathFn: outport of normalizePathQ;
  
end definitions
