# (C) Copyright International Business Machines Corporation 23 January 
# 1990.  All Rights Reserved. 
#  
# See the file USERAGREEMENT distributed with this software for full 
# terms and conditions of use. 
# File: getenum.awk
# Author: David F. Bacon
# SCCS Info: @(#)getenum.awk	1.3 3/13/90

# This awk script outputs all the enumeration value names of an enumeration 
# type "TYPENAME".  Because awk is braindamaged and doesn't support variable
# names in regex's, we have to preprocess this file and substitute the name of
# the type we want for TYPENAME.  sigh.

BEGIN {
  FS = RS
  opnum = 0
}

/TYPENAME *: *(ordered)? *enumeration/,/;/ {
  line = $1

  while (index(line, "'") != 0) {
    line = substr(line, index(line, "'")+1)
    endquote = index(line, "'")
    op = substr(line, 1, endquote-1)
    print op
    opnum++
    line = substr(line, endquote+1)
  }
}
