/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: gentab.h */
/* Author: Andy Lowry */
/* SCCS Info: @(#)gentab.h	1.3 3/13/90 */

/* Definitions for the checking-table parser and associated utilities */


typedef struct STRINGLIST {
  char *value;
  struct STRINGLIST *next;
} stringlist;

typedef struct INTLIST {
  int value;
  struct INTLIST *next;
} intlist;

typedef enum { INFERENCE, ASSIGNMENT, FAMILY } typerule_type;

typedef struct {
  int target;
  char *func;
  int source;
} inferencerule;

typedef struct {
  int target;
  char *func;
} assignmentrule;

typedef struct {
  int target;
  char *family;
} familyrule;

typedef struct TYPERULE {
  typerule_type type;
  union {
    inferencerule inf;
    assignmentrule asgn;
    familyrule fam;
  } rule;
  struct TYPERULE *next;
} typerule;

typedef struct TSRULE {
  char *func;
  intlist *operands;
  struct TSRULE *next;
} tsrule;

typedef enum { NORMAL, SPECIAL } ts_postrule_type;

typedef union {
  tsrule *postconditions;
  char *special;
} post_info;

typedef struct {
  ts_postrule_type type;
  tsrule *preconditions;
  post_info post;
} typestaterules;


#define nil 0
#ifndef TRUE
# define TRUE -1
# define FALSE 0
#endif
typedef int boolean;

/* special 'operands list' used to signal a variable operands list */
extern stringlist variable_operands;
