/* (C) Copyright International Business Machines Corporation 23 January  */
/* 1990.  All Rights Reserved.  */
/*   */
/* See the file USERAGREEMENT distributed with this software for full  */
/* terms and conditions of use.  */
/* SCCS Info: @(#)Makefile	1.14 2/7/92 */

PROCOBJS =	gentab.po

#include "includefile"

OBJECTS	=	main.o l_gentab.o y_gentab.o 
GENSRC	=	y_gentab.c l_gentab.c gentab.p tokens.h
SOURCES	=	y_gentab.y l_gentab.l 

PCOMENV =	PCOMnotcheck= PCOMnotscheck=

all: checking_table.ho gentex

install: all
	cp checking_table.ho $(DEFDIR)

checking_table.ho: gentab.p compileprocs
	$(ENV) $(HERMENV) $(HERMES) gentab

gentab.po: gentab.p
gentab.p: gentab $(HROOT)/interface/checking_table.data
	gentab < $(HROOT)/interface/checking_table.data > gentab.p

/* generator generating program */

gentab: $(OBJECTS) tabutil.o
	$(CC) -o gentab $(OBJECTS) tabutil.o -ll

gentex: $(OBJECTS) texutil.o
	$(CC) -o gentex $(OBJECTS) texutil.o -ll

y_gentab.c tokens.h: y_gentab.y 
	yacc -d y_gentab.y
	mv y.tab.c  y_gentab.c
	mv y.tab.h tokens.h

l_gentab.c: l_gentab.l tokens.h
	lex -t l_gentab.l >l_gentab.c

l_gentab.o: l_gentab.c gentab.h
y_gentab.o: y_gentab.c gentab.h
tabutil.o: tabutil.c gentab.h
texutil.o: texutil.c gentab.h

/* cleanup */

clean::
	rm -f gentab gentex checking_table.ho checking_table.ho.Z \
	$(OBJECTS) $(GENSRC)

cleantab:
	rm -f gentab.p gentab.po gentab.po.Z \
		checking_table.ho checking_table.ho.Z
