-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: distributed.d
-- Author: Andy Lowry
-- SCCS Info: @(#)distributed.d	1.2 3/13/90

-- Interfaces for C-Hermes processes that allow connections to be
-- established between processes running in distinct Hermes
-- interpreters.  An interpreter is addressed via a host name (a
-- string) and a non-negative integer which distinguishes multiple
-- interpreters running on the same machine.  These services are used
-- to establish initial connections, called "links," with a single
-- process per interpreter receiving incoming messages.  Using these
-- links, communicating processes may establish additional independent
-- channels.

distributed: using (common)

definitions
  
  -- the generic interface is used between two hermes interpreters (generally
  -- to exchange resource manager ports), but allows arbitrary in/out
  -- parameters.
  generic: callmessage (
      value: polymorph
    )
  exit { init(value) };
  
  genericQ: inport of generic { init(value) };
  genericFn: outport of genericQ;

  -- Following interface initiates network services for the
  -- interpreter.  This must be done before either setLinkingPort or
  -- getLink (see below) can be used.  C-Hermes process name: "start
  -- network" 
  startNetwork: callmessage (
    interpNo: integer		-- id for this interpreter on this machine
  )
  constant (interpNo)
  exit {full}
  exception failed {full};
  startNetworkQ: inport of startNetwork {full};
  startNetworkFn: outport of startNetworkQ;

  -- Following interface allows a process to provide an outport to which
  -- incoming messages will be forwarded.  Only a single port may ever be
  -- specified.  C-Hermes process name: "set linking port"
  setLinkingPort: callmessage (
    outport: genericFn		-- generic outport
  )
  exit {}
  exception notDistributed {full}-- network not yet started
  exception alreadySet {full};	-- linking port may not be reset
  setLinkingPortQ: inport of setLinkingPort {full};
  setLinkingPortFn: outport of setLinkingPortQ;
  
  -- Following interface allows a process to establish a link to a
  -- process running in another interpreter.  Any message sent on the
  -- returned outport will be directed to the process currently
  -- receiving link messages for that interpreter.  C-Hermes process
  -- name: "get link"
  getLink: callmessage (
    hostName: charString,	-- name of target machine
    interpNo: integer,		-- id of target interpreter on that machine
    outport: genericFn		-- binding to remote node
  )
  constant (hostName, interpNo)
  exit {full}
  exception notDistributed {init(hostName), init(interpNo)};
  getLinkQ: inport of getLink {init(hostName), init(interpNo)};
  getLinkFn: outport of getLinkQ;
  
end definitions
