-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
chainedRM: using (rManager, sysRManager) definitions
    
  rmList: ordered table of rManager { full };
  sysRMList: ordered table of sysRManager {full};
    
  chainedRMInit: callmessage (
    rmList: rmList,		-- list of rm's to chain together
    postingRM: rManager,	-- the rm for post/delete operations
    rm: rManager		-- the single RM that fronts for all of them
  )
  constant (rmList, postingRM)
  exit { full };
    
  chainedRMInitQ: inport of chainedRMInit { init(rmList), full(postingRM) };
  chainedRMInitFn: outport of chainedRMInitQ;
    
  chainedSysRMInit: callmessage (
    rmList: sysRMList,
    postingRM: sysRManager,
    rm: sysRManager
  )
  constant (rmList, postingRM)
  exit {full};
  
  chainedSysRMInitQ: inport of chainedSysRMInit 
      {init(rmList), full(postingRM)};
  chainedSysRMInitFn: outport of chainedSysRMInitQ;

end definitions

