-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)putfile.pp	1.3 1/11/92

#include "typemark.h"

putfile: using (putfile, unix) process (initQ: putFileInitQ)

  declare
    init: putFileInit;
    q: putFileQ;
    fopen: fopenFn;

  begin
    receive init from initQ;
    fopen := init.fopen;
    new q;
    connect init.putFile to q;
    return init;

-- service loop

    while TRUE repeat
      block declare
	putFile: putFile;
	file: stream;
      begin
	block begin
	  receive putFile from q;
	on (disconnected)
	  exit done;
	end block;

	block begin
	  file <- stream#(fopen(putFile.name, openType#'write'));
	on (fopen.couldNotOpen)
	  exit cantWrite;
	end block;
	call file.fwrite(putFile.file, I(size of putFile.file));
	call file.fclose();
	return putFile;
      on exit (CantWrite)
	return putFile exception CantWrite;
      on exit(done)
	exit done;
      on (others)
	discard putFile;
      end block;
    end while;

  on exit(done)
  end process
