-- () Copyright International Business Machines Corporation AUgust 27
-- 1991.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- Author: William Silverman
-- SCCS Info: @(#)main_options.pp	1.1 9/12/91


-- Extract options from a charstringlist and from the UNIX environment.
--
-- Each option in the charstringlist has the form  -String .
--
-- When  String  does not include  '=' ,  String  is the option's name
-- and the option's value is empty (uninstantiated).
--
-- String  may have the form Name=Value .
-- In that case the option's name is  Name  and the options value is the
-- charstring  Value .
--
-- Additional options are extracted from the UNIX environment.  A
-- variable in the UNIX environment whose name begins with prefix,
-- has prefix stripped, leaving  Name .  If the environment variable's
-- value is a null string, the resulting option's value is empty (see
-- above).  Otherwise, the variable's value becomes the option's value.
-- In both cases the option's name is  Name .
--
-- In any case, the value is wrapped in a polymorph (see annotate.d).
--
-- Second and subsequent occurences of a given named option are ignored.

#include "typemark.h"

main_options: using (annotate, common, main, main_options, rmanager, root)

  process (Q: optionsQ)
  
  declare
  
    cm: options;
    
    environment: root!environ;
    rm: rManager;
    options: annotations;
    prefix: charstring;
    argv: charstringlist;

  begin
    receive cm from Q;
    argv := cm.argv;
    prefix := cm.prefix;
    unwrap environment from polymorph#(cm.rm.get(S("environ"), S(""))) {init};

#include "extract_options.pp"

    cm.options <- options;
    cm.residue <- argv;
    return cm;
    
  end process
