/* (C) Copyright International Business Machines Corporation 23 January  */
/* 1990.  All Rights Reserved.  */
/*   */
/* See the file USERAGREEMENT distributed with this software for full  */
/* terms and conditions of use.  */
/* SCCS Info: @(#)Makefile	1.22 2/7/92 */

DEFOBJS	=	libinit.do errno.do initcwd.do \
		fixdefs.do fixfullint.do fixmin.do \
		itoa.do checkdefs.do checkdefs_internal.do \
		rminternal.do sorterrors.do
DEFOBJSZ	=	libinit.do.Z errno.do.Z initcwd.do.Z \
		fixdefs.do.Z  fixfullint.do.Z fixmin.do.Z \
		itoa.do.Z checkdefs.do.Z checkdefs_internal.do.Z \
		rminternal.do.Z sorterrors.do.Z

#include "includefile"

/* Set GENHROOT to something other than HROOT in order to use */
/* definition modules from a different hermes system while using the */
/* current system's compiler.  This is used by the precompilerboot */
/* target in the root Makefile */
GENHROOT =	$(HROOT)
GENBIN =	$(GENHROOT)/bin

DEFDIR =	$(GENBIN)

/* parameterize the .d.do rule so we can bootstrap with the standalone parser */
.d.do:
	$(STANDALONE) $*$(DEFSUFFIX)
STANDALONE =
DEFSUFFIX =

all:	compiledefs

boot:	
	$(MAKE) defobjs HROOT=$(HROOT) GENHROOT=$(GENHROOT) \
		STANDALONE="$(ENV) $(HERMENV) $(HPARSE)" DEFSUFFIX=".d"

/* see interface/Makefile for a description of the following bogosity */
fixdefs:
	@-rm -rf .dosave 2>/dev/null
	@mkdir .dosave
	@mv *.do .dosave
	@dlist=`make -n defobjs` ; echo $$dlist > .dlist
	@mv .dosave/?* .
	@rmdir .dosave
	@dlist=`cat .dlist` ; rm .dlist ; \
		echo $(ENV) $(HERMENV) $(HERMES) fixdefs $$dlist ; \
		$(ENV) $(HERMENV) $(HERMES) fixdefs $$dlist


checkdefs.do: checkdefs.d

checkdefs_internal.do: checkdefs_internal.d checkdefs.do

errno.do: errno.d 

fixdefs.do: fixdefs.d

fixfullint.do: fixfullint.d checkdefs_internal.do

fixmin.do: fixmin.d checkdefs_internal.do

initcwd.do: initcwd.d

itoa.do: itoa.d

libinit.do: libinit.d 

rminternal.do: rminternal.d

sorterrors.do: sorterrors.d

