-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: checkformal_typestate.p
-- Author: Jim Russell
-- SCCS Info: @(#)checkformal_typestate.p	1.5 1/15/92

-- we assume that when this process is called, it has been checked that
-- args.basetype can be found, since this will not generate an error if 
-- it can't be.  It will not crash either.
CheckFormal_Typestate: using (checkdefs_internal, errors, 
    positions) process (q: checkformal_typestateQ)
    
  declare
    args: checkformal_typestate;
    error: error;
    errtem: error;
    errObj: errorObject;
    
    errorsize: integer;
    othererror: boolean;
    empty: empty;
  begin
    receive args from q;
    
    -- There are four kinds of checks to do here:
    -- 1) syntax - make sure that the attribute has the right number of args
    -- 2) resolution - make sure that the elements of the component lists 
    --    can all be found.  This is done by args.checkCL.
    -- 3) type checking - make sure that the arguments to the attribute are of
    --    the right type.
    -- 4) compatibility - make sure that the attribute compatibility rules
    --    in the manual are satisfied.
    
    -- Note that we assume that all the abbreviation expansion allowed in
    -- the concrete syntax has been done by now (i.e. full -> inits, 
    -- init(*) insertion, minimum typestate inference for callmessages)
    -- and that the shortening done for implementation efficiency has
    -- not been done yet.
    
    -- We do these checks in two steps:
    -- 1) checks 1-3
    -- 2) check 4
    -- We only do step two if no errors were detected in step 1.
    
    -- remember how many errors we've got by now
    errorsize <- size of args.errors;
    othererror <- 'false';
    
    -- do resolution, syntax, typecheck first
    for fattr in args.ts[] inspect
        select case of fattr.attribute_name
          where ('initialized')
            if size of fattr.parameters <> 1 then
                error := args.errorTemplate;
                unite errObj.charstring from 
                "typestate attribute 'initialized' with wrong number arguments";
                insert errObj into error.objects;
                insert error into args.errors;
              else
                block
                  declare
                    prev: predefined!typename;
                  begin
                    prev := args.basetype;
                    
                    errtem := args.errortemplate;
                    unite errobj.charstring from 
                    " of typestate attribute 'initialized'";
                    insert errobj into errtem.objects;
                    call args.checkCL(fattr.parameters[0],
                        prev,
                        args.defs,
                        errtem,
                        args.errors);
                  on (CheckComponent_List.Error)
                    othererror <- 'true';
                  end block;
              end if;
          where ('case')
            if size of fattr.parameters <> 2 then
                error := args.errorTemplate;
                unite errObj.charstring from 
                "typestate attribute 'case' with wrong number arguments";
                insert errObj into error.objects;
                insert error into args.errors;
              else
                block
                  declare
                    prev: predefined!typename;
                  begin
                    prev := args.basetype;
                    
                    errtem := args.errortemplate;
                    unite errobj.charstring from 
                    " of typestate attribute 'case'";
                    insert errobj into errtem.objects;
                    call args.checkCL(fattr.parameters[0],
                        prev,
                        args.defs,
                        errtem,
                        args.errors);
                    inspect defmod in args.defs[prev.moduleid]
                      begin
                        inspect tdef in defmod.type_definitions[prev.typeid]
                          begin
                            if case of tdef.specification <> 'varianttype' then
                                error := args.errorTemplate;
                                unite errobj.charstring from 
                                "first argument of attribute 'case' not a variant";
                                insert errobj into error.objects;
                                insert error into args.errors;
                              end if;
                          end inspect;
                      end inspect;
                    
                    prev := args.basetype;
                    
                    errtem := args.errortemplate;
                    unite errobj.charstring from 
                    " of typestate attribute 'case'";
                    insert errobj into errtem.objects;
                    call args.checkCL(fattr.parameters[1],
                        prev,
                        args.defs,
                        errtem,
                        args.errors);
                    if (size of fattr.parameters[0] + 1) <>
                           size of fattr.parameters[1]
                      then
                        error := args.errorTemplate;
                        unite errobj.charstring from 
                        "second argument of attribute 'case' not component of first";
                        insert errobj into error.objects;
                        insert error into args.errors;
                      else
                        -- selectors only taking table-NAMES is a major pain in the ass
                        inspect par1 in fattr.parameters[0] begin
                            inspect par2 in fattr.parameters[1] begin
                                if (evaluate notprefix: boolean from 
                                            -- check that [0] is prefix of [1]
                                            notprefix <- 'false';
                                            for cid in par1[] inspect
                                                if cid <> par2[position of cid]
                                                  then
                                                    notprefix <- 'true';
                                                  end if;
                                              end for;
                                          end)
                                  then
                                    error := args.errorTemplate;
                                    unite errobj.charstring from 
                                    "second argument of attribute 'case' not a component of first";
                                    insert errobj into error.objects;
                                    insert error into args.errors;
                                  end if;
                              end inspect;
                          end inspect;
                      end if;
                  on (NotFound)
                    othererror <- 'true';
                    -- Either inspect defmod or inspect tdef above failed.
                    -- Don't print error here, since this will be (was) caught
                    -- when prev is (was) checked.  See note in checkdefs.d.  
                  on (CheckComponent_List.Error)
                    othererror <- 'true';
                  end block;
              end if;
          where ('checked')
            if size of fattr.parameters <> 1 then
                error := args.errorTemplate;
                unite errObj.charstring from 
                "typestate attribute 'checked' with wrong number arguments";
                insert errObj into error.objects;
                insert error into args.errors;
              else
                block
                  declare
                    prev: predefined!typename;
                  begin
                    prev := args.basetype;
                    
                    errtem := args.errortemplate;
                    unite errobj.charstring from 
                    " of typestate attribute 'checked'";
                    insert errobj into errtem.objects;
                    call args.checkCL(fattr.parameters[0],
                        prev,
                        args.defs,
                        errtem,
                        args.errors);
                    if prev <> args.typenames.program then
                        error := args.errorTemplate;
                        unite errObj.charstring from 
                        "argument of attribute 'checked' not of type predefined!program";
                        insert errObj into error.objects;
                        insert error into args.errors;
                      end if;
                  on (CheckComponent_List.Error)
                    othererror <- 'true';
                  end block;
              end if;
          
          where ('checkeddefinitions')
            if size of fattr.parameters <> 1 then
                error := args.errorTemplate;
                unite errObj.charstring from 
                "typestate attribute 'checkeddefinitions' with wrong number arguments";
                insert errObj into error.objects;
                insert error into args.errors;
              else
                block
                  declare
                    prev: predefined!typename;
                  begin
                    prev := args.basetype;
                    
                    errtem := args.errortemplate;
                    unite errobj.charstring from 
                    " of typestate attribute 'checkeddefinitions'";
                    insert errobj into errtem.objects;
                    call args.checkCL(fattr.parameters[0],
                        prev,
                        args.defs,
                        errtem,
                        args.errors);
                    -- this is no good if the module we're checking 
                    -- is predefined.d!
                    if prev <> args.typenames.defmod then
                        error := args.errorTemplate;
                        unite errObj.charstring from 
                        "argument of attribute 'checkeddefinitions' not of type predefined!definitions_module";
                        insert errObj into error.objects;
                        insert error into args.errors;
                      end if;
                  on (CheckComponent_List.Error)
                    othererror <- 'true';
                  end block;
              end if;
          where ('constraint')
            reveal fattr.attribute_name.constraint;
            
            block
              begin
                inspect defmod in args.defs[fattr.attribute_name.constraint.moduleid]
                  begin
                    inspect attdef in defmod.attr_definitions[fattr.attribute_name.constraint.attributeid]
                      begin
                        if size of attdef.parameters =
                               size of fattr.parameters
                          then
                            -- could have not found here
                            block
                              begin
                                
                                inspect scope in attdef.execution_environment.scopes[attdef.execution_environment.main_scope]
                                  begin
                                    for clist in fattr.parameters[] inspect
                                        block
                                          declare
                                            prev: predefined!typename;
                                          begin
                                            prev := args.basetype;
                    
                                            errtem := args.errortemplate;
                                            unite errobj.charstring from 
                                            " of constraint attribute";
                                            insert errobj into errtem.objects;
                                            call args.checkCL(clist,
                                                prev,
                                                args.defs,
                                                errtem,
                                                args.errors);
                                            -- do type check
                                             inspect decl in scope.declarations[attdef.parameters[position of clist]]
                                              begin
                                                reveal decl.typename.typename;
                                                if decl.typename.typename 
                                                       <> prev 
                                                  then
                                                    error := args.errorTemplate;
                                                    unite errObj.charstring 
                                                       from "argument of wrong type in constraint attribute";
                                                    insert errObj into 
                                                       error.objects;
                                                    insert error into 
                                                       args.errors;
                                                  end if;
                                              end inspect;
                                          on (NotFound, CaseError) 
                                            othererror <- 'true';
                                            -- Can't find decl in scope, or 
                                            -- decl.typename not in case 
                                            -- typename, so
                                            -- it's a bad attribute def'n.
                                            -- Don't print error here.
                                          on (CheckComponent_List.Error)
                                            othererror <- 'true';
                                          end block;
                                      end for;
                                  end inspect;
                              on (NotFound)
                                othererror <- 'true';
                                -- Can't find scope, so bad attribute def'n.
                                -- Don't print error here.
                              end block;
                          else
                            error := args.errorTemplate;
                            unite errObj.charstring from 
                            "wrong number of arguments for constraint attribute";
                            insert errObj into error.objects;
                            insert error into args.errors;
                          end if;
                      end inspect;
                  end inspect;
              on (NotFound)
                error := args.errorTemplate;
                unite errObj.charstring from 
                "definition for attribute 'constraint' not found";
                insert errObj into error.objects;
                insert error into args.errors;
              end block;
          where ('full')
            error := args.errorTemplate;
            unite errObj.charstring from 
            "attribute 'full' not allowed in abstract definitions module";
            insert errObj into error.objects;
            insert error into args.errors;
          otherwise
          end select;
      end for;
    
    -- Step 2
    if (size of args.errors <> errorsize) or othererror then
        exit premature_end;
      end if;
    -- from here on, know that there are no errors in checks 1-3, and
    -- there are almost no bogus type or attribute definitions to cause 
    -- NotFound's.

    -- declare a dummy formal attribute to do lookups efficiently
    block
      declare
        newattr: predefined!formal_attribute;
      begin
        new newattr; -- make sure it exists
        
        if size of args.ts > 0 then
            -- make sure init(*) is present
            unite newattr.attribute_name.init from empty;
            new newattr.parameters;
            insert (evaluate emptycl:predefined!component_list from
                    new emptycl;
                  end)
               into newattr.parameters;
            if not exists of args.ts[newattr] then
                error := args.errorTemplate;
                unite errObj.charstring from
                "init(*) or init(<root_variable>) not present in non-empty typestate";
                insert errObj into error.objects;
                insert error into args.errors;
              end if;
          end if;
        for fattr in args.ts[] inspect
            select case of fattr.attribute_name
              where ('initialized')
                -- don't bother with all this for init(*)
                if size of fattr.parameters[0] > 0 then
                    block
                      declare
                        newcomplist: component_list;
                        tmpcid: componentid;
                        prev: typename;
                      begin
                        -- make newcomplist component list for parent
                        newcomplist := fattr.parameters[0];
                        remove tmpcid 
                           from newcomplist[size of newcomplist - 1];
                        discard tmpcid;
                        
                        -- we know from above that if there are any fattr's 
                        -- to inspect that init(*) will be present, so we 
                        -- don't have to check for it here.
                        if size of fattr.parameters[0] > 1 then
                            unite newattr.attribute_name.init from empty;
                            new newattr.parameters;
                            insert copy of newcomplist into newattr.parameters;
                            if not exists of args.ts[newattr] then
                                error := args.errorTemplate;
                                unite errObj.charstring from
                                "init of component without init of parent";
                                insert errObj into error.objects;
                                insert error into args.errors;
                              end if;
                          end if;
                        
                        -- get the type of newcomplist
                        prev := args.basetype;
                    
                        errtem := args.errortemplate;
                        unite errobj.charstring from 
                        " SHOULDN'T HAPPEN ";
                        insert errobj into errtem.objects;
                        call args.checkCL(newcomplist, prev, args.defs,
                            errtem, args.errors);
                        
                        -- if parent was variant, check case typestate present
                        inspect mod in args.defs[prev.moduleid] begin
                            inspect tdef in mod.type_definitions[prev.typeid] 
                              begin
                                if case of tdef.specification = 'varianttype'
                                  then
                                    unite newattr.attribute_name.case
                                       from empty;
                                    new newattr.parameters;
                                    insert copy of newcomplist into
                                       newattr.parameters;
                                    insert copy of fattr.parameters[0] into 
                                       newattr.parameters at 1;
                                    if not exists of args.ts[newattr] then
                                        error := args.errorTemplate;
                                        unite errObj.charstring from
                                        "init of variant component without corresponding 'case' attribute";
                                        insert errObj into error.objects;
                                        insert error into args.errors;
                                      end if;
                                  end if;
                              end inspect;
                          end inspect;
                        
/* No longer check for presence of minimum typestate when init(cm) is */
/* present.  This way a shorten'ed module will still check OK. */
                        
--                        -- get the typename for parameters[0]
--                        prev := args.basetype;
--                    
--                        errtem := args.errortemplate;
--                        unite errobj.charstring from 
--                        " SHOULDN'T HAPPEN ";
--                        insert errobj into errtem.objects;
--                        call args.checkCL(fattr.parameters[0], prev, args.defs,
--                            errtem, args.errors);
--                        
--                        -- if we're a callmessage, check for minimum typestate
--                        inspect mod in args.defs[prev.moduleid] begin
--                            inspect tdef in mod.type_definitions[prev.typeid] begin
--                                if case of tdef.specification = 'callmessagetype'
--                                  then
--                                    reveal tdef.specification.callmessage_info;
--                                    inspect except in tdef.specification.callmessage_info.exception_specifications[tdef.specification.callmessage_info.minimum]
--                                      begin
--                                        for mattr in except.post_typestate[]
--                                          inspect
--                                            new newattr;
--                                            newattr.attribute_name :=
--                                               mattr.attribute_name;
--                                            new newattr.parameters;
--                                            for mcl in mattr.parameters[] 
--                                              inspect
--                                                insert (fattr.parameters[0] | mcl) into newattr.parameters;
--                                              end for;
--                                            if not exists of args.ts[newattr]
--                                              then
--                                                error := args.errorTemplate;
--                                                unite errObj.charstring from
--                                                "part of callmessages's minimum typestate not present";
--                                                insert errObj into error.objects;
--                                                insert error into args.errors;
--                                              end if;
--                                          end for;
--                                      end inspect;
--                                  end if;
--                              end inspect;
--                          end inspect;

   
                      on (NotFound)
                        -- moduleid or typeid bad in prev
                        -- also except may be bad
                        -- these will be caught when prev is checked
                      end block;
                  end if;
              where ('case')
                unite newattr.attribute_name.init from empty;
                new newattr.parameters;
                insert copy of fattr.parameters[0] into newattr.parameters;
                if not exists of args.ts[newattr] then
                    error := args.errorTemplate;
                    unite errObj.charstring from
                    "first argument of attribute 'case' not init";
                    insert errObj into error.objects;
                    insert error into args.errors;
                  end if;
                if exists of attr in args.ts where
                       (evaluate result:boolean from 
                            block
                              begin
                                result := 
                                   (case of attr.attribute_name = 'case' and
                                       attr.parameters[0] = fattr.parameters[0] and                                       
                                       attr.parameters[1] <> fattr.parameters[1]);
                              on (notfound)
                                result := 'false';
                              end block;
                          end)
                  then
                    error := args.errorTemplate;
                    unite errObj.charstring from
                    "conflicting 'case' attributes for same variant";
                    insert errObj into error.objects;
                    insert error into args.errors;
                  end if;
                block
                  declare 
                    prev:typename;
                  begin
                    -- get the typename for parameters[0]
                    prev := args.basetype;
                    
                    errtem := args.errortemplate;
                    unite errobj.charstring from 
                    " SHOULDN'T HAPPEN ";
                    insert errobj into errtem.objects;
                    call args.checkCL(fattr.parameters[0],
                        prev,
                        args.defs,
                        errtem,
                        args.errors);
                    inspect mod in args.defs[prev.moduleid] begin
                        inspect tdef in mod.type_definitions[prev.typeid] begin
                            inspect par2 in fattr.parameters[1] begin
                                reveal tdef.specification.variant_info;
                                inspect pinfo in tdef.specification.variant_info.case_mapping
                                       where (pinfo.component_id = par2[(size of par2) - 1])
                                  begin
                                    for vattr in pinfo.case_typestate[] inspect
                                        new newattr;
                                        newattr.attribute_name :=
                                           vattr.attribute_name;
                                        new newattr.parameters;
                                        for vcl in vattr.parameters[] inspect
                                            insert (fattr.parameters[1] | vcl)
                                               into newattr.parameters;
                                          end for;
                                        if not exists of args.ts[newattr] then
                                            error := args.errorTemplate;
                                            unite errObj.charstring from
                                            "part of variant's case typestate not present";
                                            insert errObj into error.objects;
                                            insert error into args.errors;
                                            exit done;
                                          end if;
                                      end for;
                                  end inspect;
                              end inspect;
                          end inspect;
                      end inspect;
                  on exit(done)
                    -- only need error message once
                  on (NotFound)
                    -- Must be a bad definition of prev (actually not 
                    -- possible since prev inspected above)
                    -- or case_mapping (may be possible ?),
                    -- which will be caught when that is checked.
                  end block;
              where ('checked')
                -- check that full(p) is present 
                block declare
                    newformts: formal_typestate;
                  begin
                    -- first figure out what full(p) expands to
                    unite newattr.attribute_name.full from empty;
                    new newattr.parameters;
                    insert (evaluate emptycl2:predefined!component_list from
                            new emptycl2;
                          end)
                       into newattr.parameters;
                    new newformts;
                    insert (copy of newattr) into newformts;
                    
                    call args.fixfull(args.defs, newformts,
                        args.typenames.program, args.errorTemplate, 
                        args.errors); 
              
                    -- now check that all the expanded attributes are there
                    for newfattr in newformts[] inspect
                        new newattr;
                        newattr.attribute_name := newfattr.attribute_name;
                        new newattr.parameters;
                        for newcl in newfattr.parameters[] inspect
                            insert (fattr.parameters[0] | newcl) into newattr.parameters;
                          end for;
                        if not exists of args.ts[newattr] then 
                            error := args.errorTemplate;
                            unite errObj.charstring from
                            "argument of attribute 'checked' not full";
                            insert errObj into error.objects;
                            insert error into args.errors;
                            exit done;
                          end if;
                      end for;
                  on exit(done)
                    -- only need error message once
                  end block;
                
              where ('checkeddefinitions')
                -- check that full(p) is present 
                block declare
                    newformts: formal_typestate;
                  begin
                    -- first figure out what full(p) expands to
                    unite newattr.attribute_name.full from empty;
                    new newattr.parameters;
                    insert (evaluate emptycl3:predefined!component_list from
                            new emptycl3;
                          end)
                       into newattr.parameters;
                    new newformts;
                    insert (copy of newattr) into newformts;
                    
                    call args.fixfull(args.defs, newformts, 
                        args.typenames.defmod, args.errorTemplate, 
                        args.errors);
              
                    -- now check that all the expanded attributes are there
                    for newfattr in newformts[] inspect
                        new newattr;
                        newattr.attribute_name := newfattr.attribute_name;
                        new newattr.parameters;
                        for newcl in newfattr.parameters[] inspect
                            insert (fattr.parameters[0] | newcl) into newattr.parameters;
                          end for;
                        if not exists of args.ts[newattr] then 
                            error := args.errorTemplate;
                            unite errObj.charstring from
                            "argument of attribute 'checkeddefinitions' not full";
                            insert errObj into error.objects;
                            insert error into args.errors;
                            exit done;
                          end if;
                      end for;
                  on exit(done)
                    -- only need error message once
                  end block;
                
              where ('constraint')
                unite newattr.attribute_name.init from empty;
                for param in fattr.parameters[] inspect
                    new newattr.parameters;
                    insert copy of param into newattr.parameters;
                    if not exists of args.ts[newattr] then
                        error := args.errorTemplate;
                        unite errObj.charstring from
                        "argument of constraint attribute not init";
                        insert errObj into error.objects;
                        insert error into args.errors;
                      end if;
                  end for;

                reveal fattr.attribute_name.constraint;
                inspect defmod in args.defs[fattr.attribute_name.constraint.moduleid]
                  begin
                    inspect attdef in defmod.attr_definitions[fattr.attribute_name.constraint.attributeid]
                      begin
                        for cattr in attdef.pretypestate[] inspect
                            block
                              begin
                                -- build appropriate _formal_ typestate
                                new newattr;
                                newattr.attribute_name := cattr.name;
                                new newattr.parameters;
                                for obj in cattr.objects[] inspect
                                    insert fattr.parameters[position of rid in attdef.parameters where (rid = obj.root.root)] | obj.components
                                       into newattr.parameters;
                                  end for;
                                if not exists of args.ts[newattr] then
                                    error := args.errorTemplate;
                                    unite errObj.charstring from
                                    "part of constraint's typestate not present";
                                    insert errObj into error.objects;
                                    insert error into args.errors;
                                  end if;
                              on (NotFound)
                                -- rid not found because obj.root.root is
                                -- not a parameter.  Checkconstraints will
                                -- catch this.
                              end block;
                          end for;
                      end inspect;
                  end inspect;
                -- NotFound can't happen here, since it was checked above
                                
              where ('full')
                -- shouldn't happen
                exit unexpected_full;
              otherwise
              end select;
          end for;
        return args;
      on (notfound)
        print charstring#"Whoa! unexpected notfound execption in 2nd half checkformal_typestate";
        return args;
      on (others)
        print charstring#"Whoa! unexpected others exception in last half of checkformal_typestate";
      end block;

--    return args;
  on exit(premature_end)
    return args;
    -- maybe we should return an exception?
  on (others)
    print charstring#"Whoa! others exception in checkformal_typestate";
--    return args;
  end process

