-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)fmtfmlattr.p	1.3 3/13/90

FmtFmlAttr : USING(AbsFormat)
PROCESS (FormatFormalAttributeInit : FormatFormalAttributeInport )
-- procedure to format a formal attribute
-- algorithm:  format the attributename as:
--   "(" comma-separated list of components, ")"
--  Each component is represented by * if empty
--  The list "(*)" is replaced by the empty list
  DECLARE
    FP: FormatFormalAttributeCall ;
    ComponentFormatList: Charstring;
  BEGIN
    RECEIVE FP FROM FormatFormalAttributeInit;
    FP.FormatValue <- FP.Formatters.FormatAttributeName(FP.Formatters, FP.Definitions, FP.DefinitionsMap, FP.FormalAttribute.Attribute_Name);
    ComponentFormatList <- "(";
    FOR ComponentList IN FP.FormalAttribute.Parameters WHERE('true')
      INSPECT
        IF POSITION OF ComponentList > 0
          THEN
            INSERT ',' INTO ComponentFormatList;
          END IF;
        IF SIZE OF ComponentList = 0
          THEN
            INSERT '*' INTO ComponentFormatList;
          ELSE
            MERGE FP.Formatters.FormatComponents(FP.Formatters, FP.Definitions, FP.DefinitionsMap, ComponentList, FP.Type) INTO ComponentFormatList;
          END IF; 
      END FOR;
    INSERT ')' INTO ComponentFormatList;
    IF ComponentFormatList <> "(*)"
      THEN
        MERGE ComponentFormatList INTO FP.FormatValue ;
      END IF;
    RETURN FP;
  END PROCESS
