-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- SCCS Info: @(#)fmtcomps.p	1.4 3/13/90

fmtComps : USING(AbsFormat, InferredType)
PROCESS (FormatComponentsInit : FormatComponentsInport )
  DECLARE
    FP: FormatComponentsCall ;
    Position: integer;
    ParentType: Typename; -- type of container of component being examined
  BEGIN
    RECEIVE FP FROM FormatComponentsInit;
    NEW FP.FormatValue;
    ParentType := FP.Type;
    BLOCK
      BEGIN
        FOR Component IN FP.Components WHERE('true')
          INSPECT
            Position <- POSITION OF Component;
	    IF POSITION OF Component <> 0
	      THEN
	        INSERT '.' INTO FP.FormatValue;
	      END IF;
	    BLOCK
	      BEGIN
		INSPECT DefinitionMap IN FP.DefinitionsMap WHERE(DefinitionMap.Id = ParentType.ModuleId)
		  BEGIN
		    INSPECT ComponentMap IN DefinitionMap.Components WHERE(ComponentMap.Type = ParentType.TypeId AND ComponentMap.Component = Component)
		      BEGIN
			MERGE COPY OF ComponentMap.Name INTO FP.FormatValue;
		      END INSPECT;
		  END INSPECT;
		ON (OTHERS)
		  MERGE "??" INTO FP.FormatValue;
	      END BLOCK;
	    BLOCK
	      BEGIN
		INSPECT Module IN FP.Definitions WHERE(Module.Id = ParentType.ModuleId)
		  BEGIN
		    INSPECT Definition IN Module.Type_Definitions WHERE(Definition.Id = ParentType.TypeId)
		      BEGIN
			INSPECT ComponentDeclaration IN Definition.Component_Declarations WHERE(ComponentDeclaration.Id = Component)
			  BEGIN
			    ParentType := ComponentDeclaration.Type;
			  END INSPECT;
		      END INSPECT;
		  END INSPECT;
		ON (OTHERS)
		  -- incomplete info... force question marks for
		  -- remaining components
		  ParentType.ModuleId <- UNIQUE;
	      END BLOCK;
          END FOR;
        RETURN FP;
      ON (OTHERS)
        PRINT charstring # "Something happened to Formatcomponent";
        PRINT FP.FormatValue;
        PRINT FP.Components;
        Print Position;
        PRINT ParentType;
        PRINT FP.Formatters.FormatType(FP.Formatters, FP.Definitions, FP.DefinitionsMap, ParentType);
      END BLOCK;
  END PROCESS
