/* (C) Copyright International Business Machines Corporation 23 January  */
/* 1990.  All Rights Reserved.  */
/*   */
/* See the file USERAGREEMENT distributed with this software for full  */
/* terms and conditions of use.  */
/* SCCS Info: @(#)Makefile	1.10 3/14/90 */

/* Source files */
PFILES =	root.p pcom.p dcom.p cwd.p findfile.p pathload.p \
		pathreadobj.p loadprog.p libstore.p libwriteobj.p \
		getfile.p formaterror.p load_program.p store_program.p \
		abbrev_expand.p checkcomponent_list.p checkconstraints.p \
		checkdefs.p checkformal_typestate.p do_shorten.p \
		fixdefs.p fixfull.p fixmin.p shorten.p rmanager.p userrm.p \
		main_options.p putfile.p sorterrors.p sortprocerrors.p

/* process modules generated */
ASMOBJS =	listuff.po liunstuff.po
BASICOBJS =	root.po pcom.po dcom.po cwd.po findfile.po pathload.po \
		pathreadobj.po loadprog.po libstore.po libwriteobj.po \
		getfile.po formaterror.po load_program.po store_program.po \
		rmanager.po userrm.po main_options.po putfile.po
TCOBJS =	abbrev_expand.po checkcomponent_list.po checkconstraints.po \
		checkdefs.po checkformal_typestate.po do_shorten.po \
		fixdefs.po fixfull.po fixmin.po shorten.po sorterrors.po \
		sortprocerrors.po
CHECKOBJS =	check.po checkdefinitions.po
FAKEOBJS =	fakechecked.po fakecheckeddefinitions.po
PROCOBJS =	$(BASICOBJS) $(TCOBJS) $(CHECKOBJS) $(FAKEOBJS)

/* parsed process modules which are needed before we can use the */
/* integerated front-end to go straight from .p to .po */
AOFILES	=	root.ao pcom.ao dcom.ao cwd.ao findfile.ao pathload.ao \
		pathreadobj.ao loadprog.ao libstore.ao libwriteobj.ao \
		getfile.ao formaterror.ao load_program.ao store_program.ao \
		rmanager.ao userrm.ao main_options.ao putfile.ao

/* LI files obtained from the c preprocessor */
LIFILES	=	listuff.li liunstuff.li

/* Extra flags that we need for the c preprocessor */
USECACHEFLAG =
EXTRACPPFLAGS =	-Uunix $(BOOTFLAG) $(USECACHEFLAG)

/* Use preparsed process modules when compiling */
PCOMENV =	PCOMnoparse=

#include "includefile"

/* Only take compiled process modules from standard system library */
LOADPATH =	$(PROCDIR)

/* Definitions come from the compiler support definitions directory and */
/* the standard system library, but we also include the current */
/* directory for loading .ao files */
DEFPATH =	$(HROOT)/hermes/defs:$(DEFDIR):$(HROOT)/hermes

/* We need a couple of extra suffix rules, and we also need to give .ao */
/* a higher priority than .p when selecting a suffix rule for making a */
/* .po file */
.SUFFIXES:
.SUFFIXES:	.ao .pp .p .lipp .li .po $(SUFFIXES)
.p.ao:	$<
	env $(HERMENV) $(HPARSE) $<
.ao.po:	$<
	$*

/* compilation of process modules */
/* note that check.po, checkdefinitions.po have to be specially placed  */
/* to get pcom -keeppredef  */

all:	$(AOFILES) basic checkers fakers compileprocs 
install: all
	cp $(PROCOBJS) $(PROCDIR)

chcode:
	$(CHCODECMD) $(PROCOBJS)
chcompile:
	$(CHCOMPILECMD) $(PROCOBJS)

/* following target builds only what we can build before typechecking */
basic:	$(AOFILES) $(ASMOBJS)
	@plist=`make -n basicprocs` ; if [ "$$plist" ] ; then \
		echo $(PCOMCMD) -noparse $$plist ; \
		$(PCOMCMD) -noparse $$plist ; fi
basicprocs: $(BASICOBJS)
basicinstall: basic
	cp $(BASICOBJS) $(PROCDIR)

/* following target builds the non-typemarked modules, going straight */
/* from .p to .po file */
tc:	$(PFILES)
	@plist=`make -n tcprocs` ; if [ "$$plist" ] ; then \
		echo $(PCOMCMD) $$plist ; $(PCOMCMD) $$plist ; fi
tcprocs: $(TCOBJS)
tcinstall: tc
	cp $(TCOBJS) $(PROCDIR)

tcboot:
	@-rm -f pcom.p pcom.po
	$(MAKE) basic BOOTFLAG=-DTCBOOT HROOT=$(HROOT)
cacheboot:
	@-rm -f root.p root.po
	$(MAKE) basic BOOTFLAG=-DTCBOOT HROOT=$(HROOT) \
		USECACHEFLAG=-DUSECACHE
tsboot:
	@-rm -f pcom.p pcom.ao pcom.po \
		formaterror.p formaterror.ao
	$(MAKE) basic BOOTFLAG=-DTSBOOT HROOT=$(HROOT)
final:
	@-rm -f pcom.p pcom.po dcom.p dcom.po \
		formaterror.p formaterror.ao formaterror.po
	$(MAKE) all BOOTFLAG= HROOT=$(HROOT)
	
/* the following makes sure that check is compiled with the -keeppredef flag */
checkers: $(CHECKOBJS)
check.po: check.p $(ASMOBJS)
	$(PCOMCMD) -keeppredef check
checkdefinitions.po: checkdefinitions.p
	$(PCOMCMD) -keeppredef checkdefinitions 

/* the following makes sure that fakechecked and fakecheckeddefinitions are */
/* compiled without typestate checking, so their illegal unwraps will work */
fakers: $(FAKEOBJS)
fakechecked.po: fakechecked.p
	$(PCOMCMD) -notscheck fakechecked
fakecheckeddefinitions.po: fakecheckeddefinitions.p
	$(PCOMCMD) -notscheck fakecheckeddefinitions

/* Here's how the listuff and liunstuff modules get built */
.lipp.li: $<
	$(CPP) $(HCPPFLAGS) < $< > $@
.li.po:	$<
	$(HERMENV) $(ASM) $<

listuff.po:	listuff.li
listuff.li:	listuff.lipp
liunstuff.po:	liunstuff.li
liunstuff.li:	liunstuff.lipp

/* Dependencies */
root.po:	root.ao
root.ao:	root.p
root.p:		root.pp getpaths.pp

pcom.po:	pcom.ao
pcom.ao:	pcom.p $(ASMOBJS)
pcom.p:		pcom.pp

dcom.po:	dcom.ao
dcom.ao:	dcom.p
dcom.p:		dcom.pp

formaterror.po:	formaterror.ao
formaterror.ao:	formaterror.p
formaterror.p:	formaterror.pp

main_options.po:	main_options.ao
main_options.ao:	main_options.p
main_options.p:		main_options.pp extract_options.pp

cwd.po:		cwd.ao
cwd.ao:		cwd.p

pfindfile.po:	findfile.ao
findfile.ao:	findfile.p

pathload.po:	pathload.ao
pathload.ao:	pathload.p

pathreadobj.po:	pathreadobj.ao
pathreadobj.ao:	pathreadobj.p

loadprog.po:	loadprog.ao
loadprog.ao:	loadprog.p

libstore.po:	libstore.ao
libstore.ao:	libstore.p

libwriteobj.po:	libwriteobj.ao
libwriteobj.ao:	libwriteobj.p

load_program.po: load_program.ao
load_program.ao: load_program.p

store_program.po: store_program.ao
store_program.ao: store_program.p

getfile.po:	getfile.ao
getfile.ao:	getfile.p

rmanager.po:	rmanager.ao
rmanager.ao:	rmanager.p

userrm.po:	userrm.ao
userrm.ao:	userrm.p

putfile.po:	putfile.ao
putfile.ao:	putfile.p
putfile.p:	putfile.pp

checkcomponent_list.po:	checkcomponent_list.p
checkconstraints.po:	checkconstraints.p
checkdefs.po:		checkdefs.p
checkformal_typestate.po:	checkformal_typestate.p
do_shorten.po:		do_shorten.p
fixdefs.po:		fixdefs.p
fixfull.po:		fixfull.p
fixmin.po:		fixmin.p
shorten.po:		shorten.p
sorterrors.po:		sorterrors.p
sortprocerrors.po:	sortprocerrors.p

clean::
	rm -f  root.p pcom.p dcom.p formaterror.p main_options.p $(LIFILES)
