/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: typestate.ch */
/* Author: David F. Bacon */
#ifndef lint
static char sccsinfo[] = "@(#)typestate.ch	1.4 3/13/90";
#endif

#include "cherm.h"

#include "resolve.h"

#include "predefined.cd"
#include "errors.cd"


static objectp Formalts;


void
p_init_formal_typestate()
{
    Formalts = new_object();
    avl_new_table(Formalts, whole_key);
}


objectp
p_get_formal_typestate()
{
    return(Formalts);
}


void
p_add_formal_attribute(Attribute)
objectp Attribute;		/* in formal_attribute */
{
    if (insert(Formalts, Attribute) is DuplicateKey) {
	fe_error(Inhibit_Codegen, errorcode__general_error,
		"A typestate is a set, not a multiset");
	discard(Attribute);
    }

}


objectp				/* out formal_attribute */
p_formal_attribute(Attrname, Formalobjs)
objectp Attrname;		/* in attribute_info */
objectp Formalobjs;		/* in formal_objects */
{
    objectp Attribute;


    Attribute = new_object();
    new_record(Attribute, formal_attribute);

    move(Attribute@formal_attribute__attribute_name, Attrname);
    move(Attribute@formal_attribute__parameters, Formalobjs);


    return(Attribute);
}


objectp
p_formal_whole_object()
{
    void p_init_formal_object_name_list();
    objectp p_get_formal_object_name_list();
    void p_add_formal_object_name();
    objectp p_whole_formal_object();


    p_init_formal_object_name_list();
    p_add_formal_object_name(p_whole_formal_object());
    return(p_get_formal_object_name_list());
}


objectp				/* out component_list */
p_whole_formal_object()
{
    objectp Componentlist;	/* component_list */


    Componentlist = new_object();
    vec_new_table(Componentlist, 0);
    return(Componentlist);
}



objectp
p_formal_association()
{
    fe_error(Stop_Now, errorcode__general_error,		/* fix later */
	     "Formal associations are not supported in version 0");
}
