# (C) Copyright International Business Machines Corporation 23 January 
# 1990.  All Rights Reserved. 
#  
# See the file USERAGREEMENT distributed with this software for full 
# terms and conditions of use. 
# SCCS Info: @(#)ident.awk	1.2 3/13/90

#
# identifier.awk
#
# takes as input the file "keywords" with all the words from the file "reswords"
# filtered out, and produces a yacc production for an identifier, which can 
# be any non-reserved keyword or an alphanumeric symbol.
#
BEGIN {
	print "identifier : T_SYMBOL { $$ = downcase(copystring(yytext)); } ;"
}

/^[A-Z]+$/ {
	print "identifier : " $1 " { $$ = downcase(copystring(\"" $1 "\")); } ;" 
}
