-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
disinternal: using (predefined,interpform,stdenv,listuff,disassembler)
  definitions
    dests: table of integer {init} keys(*);
    label: record (
	prog_name: predefined!charstring,
	line_base: predefined!charstring,
	label_base: predefined!charstring,
	exit_base: predefined!charstring,
	indentation: predefined!integer,
	max_blanks: predefined!integer,
	exits: predefined!exit_printmap,
	dests: dests
      );
    -- all the Fn's must be "procedure of"'s
    dis: record (
	pms: printmaps,
	label: label,
	operation: disoperationFn,
	opcode: disopcodeFn,
	operand: disoperandFn,
	qualifier: disqualifierFn,
	integer: disintegerFn,
	blanks: disblanksFn
      );
    -- A table relating process id's to the names we've chosen for them
    procNames: table of procName {full} keys (id);
    procName: record (
      id: processid,
      name: charstring
    );
    -- disoperant returns a charstring representation of an opcode
    disoperation: callmessage (
	dis: dis,
	operation: interpform!operation,
	procnames: procNames,
	rep: predefined!charstring
      )
    constant (operation, procnames)
    exit {full}
    exception Unsupported {full(dis),full(operation),full(procnames)};
    disoperationQ: inport of disoperation 
       {full(dis),full(operation),full(procnames)};
    disoperationFn: outport of disoperationQ;
    -- disopcode returns a charstring representation of an opcode
    disopcode: callmessage (
	opcode: interpform!opcode,
	rep: charstring
      )
    constant (opcode)
    exit {full}
    exception Unsupported {init(opcode)};
    disopcodeQ: inport of disopcode {init(opcode)};
    disopcodeFn: outport of disopcodeQ;
    -- disoperand returns a charstring representation of an operand
    disoperand: callmessage (
	dis: dis,
	operand: interpform!operand,
	rep: charstring
      )
    constant (operand)
    exit {full};
    disoperandQ: inport of disoperand {full(dis),init(operand)};
    disoperandFn: outport of disoperandQ;
    -- disqualifier returns a charstring representation of a qualifier
    disqualifier: callmessage (
	dis: dis,
	qualifier: interpform!qualifier,
	context: opcode,
	procnames: procNames,
	rep: predefined!charstring
      )
    constant (qualifier,context,procnames)
    exit {full}
    exception Unsupported
	{full(dis),full(qualifier),init(context),full(procnames)};
    disqualifierQ: inport of disqualifier 
       {full(dis),full(qualifier),init(context),full(procnames)};
    disqualifierFn: outport of disqualifierQ;
    disinteger: callmessage (
	integer: predefined!integer,
	rep: predefined!charstring
      )
    constant (integer)
    exit {full};
    disintegerQ: inport of disinteger {init(integer)};
    disintegerFn: outport of disintegerQ;
    disblanks: callmessage (
	count: predefined!integer,
	ret: predefined!charstring
      )
    constant (count)
    exit {full};
    disblanksQ: inport of disblanks {init(count)};
    disblanksFn: outport of disblanksQ;
  end definitions
