-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: varcaseid.pp
-- Author: Andy Lowry
-- SCCS Info: @(#)varcaseid.pp	1.4 10/1/90

-- This process takes an object name, which must correspond to a
-- component of a variant, and determines the case ID number for that
-- component.

#include "typemark.h"
#include "codegen.h"

varCaseID: using (cgInternal)

process (Q: varCaseIDQ)
  
declare
  args: varCaseID;
  objCopy: objectname;
  lastComp: componentid;
  varTDef: type_definition;
  varInfo: variant_info;
begin
  receive args from Q;
  
  -- Make a copy of the object name so we can trash it
  objCopy := args.objname;
  -- Extract the last component
  remove lastComp from 
      AREF(tmp,objCopy.components,I(I(size of objCopy.components)-ONE));
  -- Get the type definition for the container type, and extract the
  -- variant desciptor info
  varTDef <- type_definition#(FNS.typeDef(
      typename#(args.cgData.Proc.objType(objCopy))));
  reveal varTDef.specification.variant_info;
  varInfo := varTdef.specification.variant_info;
  -- Now locate the info for our last component and extract the case ID
  inspect x in varInfo.case_mapping where (B(x.component_id = lastComp)) begin
    args.caseID := x.case_id;
  end inspect;
  
  return args;
  
end process
