-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: typedef.pp
-- Author: Andy Lowry
-- SCCS Info: @(#)typedef.pp	1.5 2/14/92

-- This process returns a type definition given its typename.  The
-- process acts like a server and is initialized with the program data
-- portion of the standard cgData structure.  The init call returns a
-- service capability and a shutdown signal capability.

#include "typemark.h"
#include "codegen.h"

typeDef: using (cgInternal, cgInit, common)

process (initQ: typeDefInitQ)
  
declare
  initArgs: typeDefInit;
  Q: typeDefQ;
  shutQ: signalQ;
  defMods: definitions_modules;
begin
  receive initArgs from initQ;
  
  -- copy out the definitions modules from the absprog
  defMods := initArgs.progData.defMods;
  -- create the service and shutdown ports and establish connections
  new Q; connect initArgs.typeDef to Q;
  new shutQ; connect initArgs.shutdown to shutQ;
  return initArgs;

  -- Now take service requests until we get the shutdown signal
  while TRUE repeat
    select
    event Q
      -- Look up a type definition given its typename
      block declare
	args: typeDef;
      begin
	receive args from Q;
	inspect defMod in defMods[args.name.moduleid] begin
	  args.def := type_definition#(
	    defMod.type_definitions[args.name.typeid]);
	end inspect;
	return args;
      end block;
	
    event shutQ
      -- shut down the server
      exit done;
      
    otherwise
      exit cantHappen;
      
    end select;
  end while;
  
on exit(done)
  -- all finished
  
on exit(cantHappen)
  print S("CantHappen exit taken in typedef");
end process
