-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: cgexprblock.pp
-- Author: Andy Lowry
-- SCCS Info: @(#)cgexprblock.pp	1.4 2/14/92

-- This module translates an expression block.  This really just
-- consists of translating the clause that makes up the body of the
-- expression block, so there's not much to it.

#include "typemark.h"
#include "codegen.h"

cgExprBlock: using (cginternal)

process (Q: cgStmtQ)
  
declare
  args: cgStmt;
begin
  receive args from Q;
  reveal args.stmt.qualifier.expression;
  
  -- Locate the body clause and translate it
  inspect scope in args.cgData.Proc.proc.executable_part.scopes
	[args.stmt.qualifier.expression.scope] begin
    call FNS.cgClause(scope.clause,args.cgData);
  end inspect;
  
  -- That was easy!
  return args;
  
end process
