-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: cgcase.pp
-- Author: Andy Lowry
-- SCCS Info: @(#)cgcase.pp	1.2 2/15/92

-- This process translates a 'case' statement.  The LI opcode used is
-- either 'case' or 'ord_case', depending on whether the variant
-- type in question is based on an ordered enumeration type.

#include "typemark.h"
#include "codegen.h"

cgcase: using (interpform, cgInternal)

process (Q: cgStmtQ)

declare
  args: cgStmt;
  op: interpform!operation;
  tdef: type_definition;
  empty: empty;
begin
  receive args from Q;

  -- allocate the instruction and generate the two operand addresses
  new op;
  new op.operands;
  insert interpform!operand#(args.cgData.Proc.objAddr(
      objectname#(AREF(tmp,args.stmt.operands,ZERO)))) into op.operands;
  insert interpform!operand#(args.cgData.Proc.objAddr(
      objectname#(AREF(tmp,args.stmt.operands,ONE)))) into op.operands;

  -- Get the variant type defintion
  tdef <- type_definition#(FNS.typeDef(typename#(args.cgData.Proc.objType(
	  objectname#(AREF(tmp,args.stmt.operands,ONE))))));

  -- find the case type
  reveal tdef.specification.variant_info;
  tdef <- type_definition#(FNS.typeDef
	(tdef.specification.variant_info.case_type));

  -- check whether the enumeration is ordered
  reveal tdef.specification.enumeration;
  if tdef.specification.enumeration.ordered then
    op.opcode <- interpform!opcode#'ord_case';
  else
    op.opcode <- interpform!opcode#'case';
  end if;
  
  unite op.qualifier.empty from empty;
  
  -- Add the new instruction to the current basic block
  ADDINSTR(op);

  return args;

end process


