-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chphase3.p	1.2 2/4/92

-- This process completes the transformation of one program.
--
-- Input is a statements table, an operands table a cblocks table and a
-- prog, lipart.
--
-- Output is a new code table in lipart, a chpart text string (the
-- transformed C-code), and a new value of prog.size (see chphase3).
--
-- First, chupstate is called to update statement numbers, modifying
-- position for each statement, and adjusting branch labels as necessary.
--
-- Then the operands are counted and their Ids are adjusted.  Unreferenced
-- operands are not counted.
--
-- Then the residual li-code is collected.  Unless the "interpret"
-- option is used, the resultant table consists entirely of 'escape'
-- operations - note that in this case the generated qualifier of each
-- escape instruction is equal to the position of the operation.
--
-- Finally, the C-coded text is initiallized, and chencode is called to
-- generate the rest of the C program (suffixed by a little more canned
-- code).
--

chphase3: using(chdescriptors, chinternal, chphase3, chtransform,
    interpform, string)
linking (chupstate, chencode)

  process(Q: phase3Q)
    
  declare
    
    cm: phase3;
    
    stx: integer;
    statement: ch_statement;
    minimum_operand_index: integer;
    operation: operation;
    id: operand;
    
    replace: replace;
    replaces: replaces;
    chop: ch_operand;
    pos: integer;
    
    newsize: integer;
    newcode: code;
    ccode: charstring;
    ops: charstring;
    suffix: char;
    
    i: integer;
    interpret: boolean;
    arguments: integer;

  begin
    minimum_operand_index <- 3;
    receive cm from Q;
    if cm.ch.options.verbose then
	call cm.ch.put("phase3 ");
      end if;
    
    -- unify cblocks
--    call (unify_cblocksFn#(create of process chunify_cblocks))
--       (cm.statements, cm.cblocks);
    
    -- update statement indices
    call (upstateFn#(create of process chupstate))
       (cm.statements, cm.references);
    
    -- update operand ids (cm.operands, cm.lipart.size!)
    new replaces;
    new replace;
    newsize := minimum_operand_index;
    replace.new := newsize;
    for op in cm.operands where(op.Id[0] >= minimum_operand_index) inspect
	pos <- position of op;
	if op.References + op.Assignments > 0 then
	    inspect ix in op.Id[0] begin
		replace.old := ix;
		block begin
		    insert replace into replaces;
		    new replace;
		    newsize <- newsize + 1;
		    replace.new := newsize;
		  on(DuplicateKey)
		  end block;
		inspect r in replaces[ix] begin
		    if r.old <> r.new then
			remove chop from cm.operands[pos];
			remove i from chop.Id[0];
			insert copy of r.new into chop.Id at 0;
			insert chop into cm.operands at pos;
		      end if;
		  end inspect;
	      end inspect;
	  else -- debugging
	    remove chop from cm.operands[pos];
	    remove i from chop.Id[0];
	    insert -pos into chop.Id at 0;
	    insert chop into cm.operands at pos;
	  end if;
      end for;
    cm.lipart.size <- newsize;
    
    -- Collect residual li-code (cm.statements, cm.lipart.code!, interpret!,
    --				 arguments)
    
    new newcode;
    interpret <- 'false';
    arguments <- 1;
    for st in cm.statements[] inspect
	statement := st;
	if statement.locus = 'interpret' then
	    interpret <- 'true';
	    new operation;
	    operation.opcode <- statement.opcode;
	    new operation.operands;
	    for ox in statement.operands[] inspect
		if ox = -1 then
		    new id;
		  else
		    inspect op in cm.operands[ox] begin
			id := op.Id;
		      end inspect;
		  end if;
		insert id into operation.operands;
	      end for;
	    operation.qualifier <- statement.qualifier;
	    insert operation into newcode;
	  else
	    if statement.locus <> 'omit' then
		if size of st.operands > arguments then
		    arguments <-  size of st.operands;
		  end if;
	      end if;
	    if statement.locus <= 'escape' 
		  or (statement.locus = 'omit' and statement.opcode = 'escape')
	      then
		new operation;
		operation.opcode <- 'escape';
		new operation.operands;
		stx <- position of st;
		inspect cb in cm.cblocks where(cb.first = stx)
		  begin
		    unite operation.qualifier.integer from position of cb;
		  end inspect;
		insert operation into newcode;
	   -- else 'ccode' or 'omit' without a dummy 'escape' required
	      end if;
	  end if;
      end for;
    cm.lipart.code <- newcode;

    -- collect c-code (cm.cblocks, cm.statements, cm.operands, cm.chpart!,
    --		       cm.lipart.pool!)
    ccode <- "#include ""chdecl.h""";
    insert 'NL' into ccode;
    merge "void CH_" into ccode;
    merge copy of cm.lipart.name into ccode;
    merge "(current, sched, cop)" into ccode;
    insert 'NL' into ccode;
    merge "#define ARGUMENTS " into ccode;
    merge cm.ch.itoa(arguments + 2) into ccode;
    insert 'NL' into ccode;
    if interpret then
	merge "#define INTERPRET" into ccode;
	insert 'NL' into ccode;
      end if;
    merge "#include ""chhead.h""" into ccode;
    insert 'NL' into ccode;
    
    call (encodeFn#(create of process chencode))
       (cm.ch, cm.cblocks, cm.statements,
	cm.operands, ccode, cm.lipart.pool);
    merge "#include ""chtail.h""" into ccode;
    insert 'NL' into ccode;
    cm.chpart <- ccode;

    return cm;
  
  end process
