-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chimprove.d	1.1 9/25/91

chimprove: using(chdescriptors, chinternal, chtransform, interpform)

  definitions
    
    adjust : callmessage(
	as : assignment,
        ox : integer,
        operands : ch_operands
      )
    constant(as, ox)
    exit {full};
    adjustQ : inport of adjust {full};
    adjustFn : outport of adjustQ;
    
    improver : callmessage(
        ch : chcontrols,
        statements : ch_statements,
        operands : ch_operands,
	stx: integer,
	adjust : adjustFn
      )
    constant (stx, adjust)
    exit {full}
    exception drop {full};
    improverQ : inport of improver {full(ch), init(statements),
	init(operands), init(stx), init(adjust)};
    improverFn : outport of improverQ;
    
    peeper : callmessage(
        ch : chcontrols,
        statements : ch_statements,
        operands : ch_operands,
	sxs: statement_index_list,
	adjust : adjustFn,
	continue : boolean
      )
    constant (sxs, adjust)
    exit {full}
    exception drop {full};
    peeperQ : inport of peeper {full(ch), init(statements),
	init(operands), init(sxs), init(adjust), init(continue)};
    peeperFn : outport of peeperQ;
    
    computed : callmessage(
        ch : chcontrols,
        statements : ch_statements,
        operands : ch_operands,
	stx: integer,
	opcode: opcode,
	qual: interpform!qualifier
      )
    constant (stx)
    exit {full(ch), init(statements), init(operands), init(stx)}
    exception constant {full};
    computedQ : inport of computed {full(ch), init(statements),
	init(operands), init(stx)};
    computedFn : outport of computedQ;
    
    operations : callmessage(
        ch : chcontrols,
	cblocks: cblocks,
        statements : ch_statements,
        operands : ch_operands,
	adjust : adjustFn,
	continue : boolean
      )
    constant (cblocks, statements, adjust)
    exit {full};
    operationsQ : inport of operations {full(ch), init(cblocks),
	init(statements), init(operands), init(adjust), init(continue)};
    operationsFn : outport of operationsQ;
    
  end definitions

