chGetConfig: using (chinternal, unix, annotate, terminalIO)
process (Q: getChConfigurationQ)
declare
  args: getChConfiguration;
  file: stream;
  pos: integer;
  pos2: integer;
  line: charstring;
  thisarch: charstring;
  arch: charstring;
  name: charstring;
  junk: char;
  blanks: charstring;
  param: annotation;
  oldparam: annotation;
begin
  receive args from Q;

  -- extract our architecture name
  block begin
    inspect entry in args.environ["HARCH"] begin
      thisarch := entry.value;
    end inspect;
  on (notFound)
    thisarch <- "";
  end block;

  new args.configuration;

  -- open the configuration file
  block begin
    file <- args.fopen(args.filename, 'read');
    -- read parameters from the file
    while 'true' repeat
      block begin
	line <- file.gets();
	-- deal with continuation lines
	block begin
	  while line[size of line - 1] = '\' repeat
	    remove junk from line[size of line - 1];
	    line <- line | file.gets();
	  end while;
	on (notFound, getStringIntf.endOfInput)
	end block;

	pos <- position of c in line where (c = '=');
	extract name from c in line where (position of c < pos);
	remove  junk from line[];	-- eat the equal sign
	name <- name | "()";		-- ensure no notfounds below
	pos <- position of c in name where (c = '(');
	pos2 <- position of c in name where (c = ')');
	extract arch from c in name where
	    (position of c > pos and position of c < pos2);
	extract blanks from c in arch where (c = ' ');-- no blanks allowed
	if arch <> thisarch and arch <> "" then
	  exit wrongarch;
	end if;
	name <- every of c in name where (position of c < pos);
	extract blanks from c in name where (c = ' ');
	-- remove trailing spaces from value part
	block begin
	  junk <- ' ';
	  while junk = ' ' repeat
	    remove junk from line[];
	  end while;
	  insert junk into line at 0;
	on (notFound)
	end block;
	-- construct an annotation for this parameter
	new param;
	param.name <- name;
	wrap line as param.thing;
	block begin
	  insert param into args.configuration;
	on (duplicateKey)
	  -- if this is an architecture-specific entry, it overrides
	  -- whatever came before
	  if arch <> "" then
	    remove oldparam from args.configuration[param.name];
	    insert param into args.configuration;
	  end if;
	end block;
      on (getstringIntf.endOfInput)
	call file.fclose();		-- all done
	exit done;
      on (notFound)
	-- ill-formed line in param file... ignore it
      on exit(wrongarch)
      end block;
    end while;
  on exit(done)
  on (others)
    -- end of file, etc... return whatever we got, may be empty
  end block;

  return args;

end process
