-- (C) Copyright International Business Machines Corporation 16 September
-- 1991.  All Rights Reserved.
--
-- See the file USERAGREEMENT distributed with this software for full
-- terms and conditions of use.
-- SCCS Info: @(#)chencode.d	1.2 3/2/92

chencode: using(chdescriptors, chinternal, chphase3, chtransform,
    common, interpform)

  definitions
    
    encode_environment : record(
	cbx : integer,			-- cblock index
	stx : integer,			-- statement index
	counter : integer,		-- iteration counter
	select_flag : boolean,		-- kluge for 'select'
					    -- 'false' => counting operands
					    -- 'true' =>  counting labels
	cblocks : cblocks,		-- all of the cblocks
	operands : ch_operands,		-- all of the operands
	statements : ch_statements	-- all of the instructions
      );
    
    encode_operand : callmessage(
	macro : operand_macro,
	operand : ch_operand,
	parameters : template_parameters,
	ch: chcontrols,
	string : charstring
      )
    constant (macro, operand, parameters)
    exit {full};
    encode_operandQ : inport of encode_operand {init(macro), full(operand),
      init(parameters), full(ch)};
    encode_operandFn : outport of encode_operandQ;

    encode_qualifier : callmessage(
	st : ch_statement,
	ch : chcontrols,
	pool : pooled_qualifiers,	-- pooled compound qualifiers
	string : charstring
      )
    constant (st)
    exit {full};
    encode_qualifierQ : inport of encode_qualifier
       {full(st), full(ch), init(pool)};
    encode_qualifierFn : outport of encode_qualifierQ;
    
    encodingsInit: callmessage (
      encodings: encodingsFn
    )
    exit {full};
    encodingsInitQ: inport of encodingsInit {};
    encodingsInitFn: outport of encodingsInitQ;
    
    encodings : callmessage(
	ch : chcontrols,
	env : encode_environment,
	choose : choice,
	parameters : template_parameters,
	opsin : template_operations,
	opsout : template_operations
      )
    constant (choose)
    exit {full(ch), full(env), init(opsout), init(parameters)};
    encodingsQ : inport of encodings {full(ch), full(env), init(choose),
      init(parameters), init(opsin), init(opsout)};
    encodingsFn : outport of encodingsQ;
    
  end definitions


