/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: rpcclient.ch */
/* Author: David F. Bacon */
#ifndef lint
static char sccsinfo[] = "@(#)rpcclient.ch	1.5 8/28/91";
#endif

#define _BSD 43

#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>

#include "rpc.h"
#include "distrib.h"
#include "storage.h"

#define IP_INIT 0
#define IP_SERVE 1


CProc(C_get_link)
{
    predef_exception remport_enq();

    lobject(Callmsg);
    objectp Initp;


    Initp = & current->ep.c->initport;

    switch (current->ip) {

      case IP_INIT: {
	  current->ip = IP_SERVE;
	  c_wait(sched, current, Initp);
	  return;
      }

      case IP_SERVE: {
	  char *server;
	  u_long version;
	  channel *chan = nil;
	  struct hostent *hp;


	  if (c_receive(Callmsg, Initp) == FAILURE) {
	    if (c_disconn(Initp)) {
	      c_discard(sched, Initp);
	      c_endprocess(sched, current);
	    }
	    else
	      c_wait(sched, current, Initp);
	    break;
	  }

	  server = stringval(Callmsg@getlink__hostname);
	  version = (u_long) integerval(Callmsg@getlink__interpno);

	  chan = new(channel);
	  if (chan is nil)
	    goto cleanup;

	  chan->type = RemotePort;
	  chan->port_enq = remport_enq;
	  chan->disconnected = FALSE;
	  chan->refcount = 1;

	  if ((hp = gethostbyname(server)) is NULL) 
	    goto cleanup;

	  chan->info.remote.addr = LINKPORTADDR; /* special linked port */
	  bcopy(hp->h_addr, (caddr_t) chan->info.remote.interp.hostname, 
		HOSTIDSIZE);
	  chan->info.remote.interp.number = version;

	  Callmsg@getlink__outport->value.outport = chan;
	  Callmsg@getlink__outport->tsdr = & dr_outport;
	  c_return(sched, Callmsg);
	  c_wait(sched, current, Initp);
	  return;

	cleanup: 
	  if (chan)
	    dispose(chan, channel);
	  c_discard(sched, Callmsg);
	  c_wait(sched, current, Initp);
	  return;
      }
    } /* switch(current->ip) */
}
