/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* File: parsedef.ch */
/* Author: David F. Bacon */
#ifndef lint
static char sccsinfo[] = "@(#)parsemod.ch	1.8 1/25/92";
#endif

#include "cfunc.h"

#include "feproc.h"

#include "initparse.cd"
#include "parse.cd"

/* define meanings of pcb's ip field: */
#define IP_INIT 0
/* IP_INIT means we are waiting to do initialization processing */
#define IP_SERVE 1
/* IP_SERVE means we are initialized and are waiting for parse requests */


static object Porthack;
objectp Porthackp = & Porthack;

static object ParsedefCmsg;
objectp ParsedefCmsgp = &ParsedefCmsg;

static object ParseprocCmsg;
objectp ParseprocCmsgp = &ParseprocCmsg;

schedp schedhack;


CProc(C_parsedef)
{
    int fe_imain();
    void set_isdefmod();
    void def_die();

    lobject(CMsg);
    objectp Initp;
    objectp Servp;
    objectp Ports;
    feprocessdata *ep;


    ep = (feprocessdata *) current->ep.c;
    Initp = & ep->initport;
    Servp = & ep->serviceport;
    Ports = & ep->portrec;

    schedhack = sched;

    (void) copy(CMsg, Bottom);
    (void) copy(ParsedefCmsgp, Bottom);

    switch (current->ip) {

      case IP_INIT: {		/* initialization and bindings */
	  if (c_receive(CMsg, Initp) is FAILURE) /* if nothing yet ... */
	    if (c_disconn(Initp)) {
	      c_discard(sched, Initp);
	      c_endprocess(sched, current);
	    }
	    else
	      c_wait(sched, current, Initp); /* just wait for init request */
	  else {
	      if (c_new_inport(Servp) is FAILURE)
		def_die();
	      if (c_connect(CMsg@initparsedef__parsedef, Servp) is FAILURE)
		def_die();
	      if (copy(Ports, CMsg@initparsedef__fns) isnt Normal)
		def_die();
	      cheapcopy(Porthackp, Ports);

	      (void) discard(Initp);
	      current->ip = IP_SERVE;
	      c_wait(sched, current, Servp);
	      c_return(sched, CMsg);
	  }
	  break;
      }

      case IP_SERVE: {
	  if (c_receive(ParsedefCmsgp, Servp) is FAILURE) {
	    if (c_disconn(Servp)) {
	      c_discard(sched, Servp);
	      c_discard(sched, Ports);
	      c_endprocess(sched, current);
	    }
	    else
	      c_wait(sched, current, Servp);
	    break;
	  }
	  set_isdefmod(TRUE);
	  felex_setinput(nil, stringval(ParsedefCmsgp@parsedef__file));
	  set_srcfile_name(stringval(ParsedefCmsgp@parsedef__filename));
	  if (!vec_new_table(ParsedefCmsgp@parsedef__errors, nil))
	    def_die();
	  (void) fe_imain();
	  
	  c_return(sched, ParsedefCmsgp);
	  c_wait(sched, current, Servp);

	  break;
      }

      default: {
	  def_die();
	  break;
      }

    }
}


static void
def_die()
{
    void abort_nili();

    abort_nili("C_parsedef");
}


CProc(C_parseproc)
{
    int fe_imain();
    void proc_die();
    void set_isdefmod();

    lobject(CMsg);
    objectp Initp;
    objectp Servp;
    objectp Ports;
    feprocessdata *ep;


    ep = (feprocessdata *) current->ep.c;
    Initp = & ep->initport;
    Servp = & ep->serviceport;
    Ports = & ep->portrec;

    schedhack = sched;

    (void) copy(CMsg, Bottom);
    (void) copy(ParseprocCmsgp, Bottom);

    switch (current->ip) {

      case IP_INIT: {		/* initialization and bindings */
	  if (c_receive(CMsg, Initp) is FAILURE) /* if nothing yet ... */
	    if (c_disconn(Initp)) {
	      c_discard(sched, Initp);
	      c_endprocess(sched, current);
	    }
	    else
	      c_wait(sched, current, Initp); /* just wait for init request */
	  else {
	      if (c_new_inport(Servp) is FAILURE)
		proc_die();
	      if (c_connect(CMsg@initparseproc__parseproc, Servp) is FAILURE)
		proc_die();
	      if (copy(Ports, CMsg@initparseproc__fns) isnt Normal)
		proc_die();
	      cheapcopy(Porthackp, Ports);

	      (void) discard(Initp);
	      current->ip = IP_SERVE;
	      c_wait(sched, current, Servp);
	      c_return(sched, CMsg);
	  }

	  break;		/* stupid dipshit language.... */
      }

      case IP_SERVE: {
	  if (c_receive(ParseprocCmsgp, Servp) is FAILURE) {
	    if (c_disconn(Servp)) {
	      c_discard(sched, Servp);
	      c_discard(sched, Ports);
	      c_endprocess(sched, current);
	    }
	    else
	      c_wait(sched, current, Servp);
	    break;
	  }
	  set_isdefmod(FALSE);
	  set_srcfile_name(stringval(ParseprocCmsgp@parseproc__filename));
	  felex_setinput(nil, stringval(ParseprocCmsgp@parseproc__file));
	  if (!vec_new_table(ParseprocCmsgp@parseproc__errors, nil))
	    proc_die();
	  (void) fe_imain();
	  
	  c_return(sched, ParseprocCmsgp);
	  c_wait(sched, current, Servp);

	  break;		/* ditto the above */
      }

      default: {
	  proc_die();
	  break;		/* symmetry in dipshitiness */
      }

    }
}


static void
proc_die()
{
    void abort_nili();

    abort_nili("C_parseproc");
}
