/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* MiniC common declarations
** Andy Lowry, Apr 1989
** SCCS Info: @(#)minic.h	1.2 3/13/90
*/

/* Typedefs for expressions, c types, and symbol table entries, all of */
/* which can reference each other via pointers (which is why the */
/* typedefs have to come first... */
typedef struct expr EXPR;	/* arbitrary C expression */
typedef struct ctype CTYPE;	/* an arbitrary C data type */
typedef struct s_entry S_ENTRY;	/* an entry in the symbol table */

/* Now bring in the actual type definitions... */
#include "expr.h"
#include "ctype.h"
#include "symtab.h"

 
/* inputfile and linecount are used in error messages to give the */
/* location of the error... cpp line markers are recognized and */
/* understood by the lexical analyzer. */
extern char *inputfile;
extern int linecount;

extern int blklevel;		/* current block nesting level */

/* macro to allocate storage for a piece of data -- NULL on failure */
#define new(type) ((type *) malloc(sizeof(type)))


#ifndef NULL
#  define NULL 0
#endif

/* function declarations */
char *malloc();
int yylex();			/* lexical analyzer */
int yyparse();			/* yacc-constructed parser */
char *copystring();		/* allocates stg for a copy of a string */
S_ENTRY *lookup();		/* locate/create symbol table entry */
void free_entry();		/* drop a reference to a symtab entry */
void freelevel();		/* free all symtab entries at given */
				/* block nesting level */
void free_ctype();		/* drop a reference to a C type structure */
void free_expr();		/* drop a reference to an expression */
				/* structure */
