/* (C) Copyright International Business Machines Corporation 23 January */
/* 1990.  All Rights Reserved. */
/*  */
/* See the file USERAGREEMENT distributed with this software for full */
/* terms and conditions of use. */
/* SCCS Info: @(#)main.c	1.5 3/13/90 */

#include "li.h"
#include "storage.h"

#include <stdio.h>

char yytext[256];

char *filename;

extern int yylineno;

main(argc, argv)
int argc;
char *argv[];
{
    void init_debug();

    int retcode;


    if (argc > 1) {
	if (freopen(argv[1], "r", stdin) is NULL) {
	    fprintf(stderr, "Couldn't open %s\n", argv[1]);
	    exit(1);
	}
	filename = argv[1];
    } else
      filename = nil;

    make_quopy_datareps();
    init_storage();
    init_cherm();
    lexinit();
    init_debug();

    retcode = yyparse();

    if (retcode isnt 0)
      printf("Error, code %d.\n", retcode);

    exit(retcode);
}


void
yyerror(s)
char *s;
{
    if (filename)
      fprintf(stderr, "\"%s\", line %d near '%s'",
	      filename, yylineno, yytext);
    else
      fprintf(stderr, "line %d near '%s'", yylineno, yytext);

    fprintf(stderr, ": %s\n", s);
}
