/* (C) Copyright International Business Machines Corporation 23 January  */
/* 1990.  All Rights Reserved.  */
/*   */
/* See the file USERAGREEMENT distributed with this software for full  */
/* terms and conditions of use.  */
/* SCCS Info: @(#)Makefile	1.16 2/7/92 */

#include "includefile"

LIBS	=	$(LIBDIRS) -lhermi -lcherm -lcfunc -lfe -lhaux -ll $(MACHLIBS)

OBJS	=	asm.o asmlex.o main.o actions.o defacts.o stubs.o

YACC	=	yacc
YFLAGS	=	-v


all:	asm

install: asm
	cp asm $(ASM)

asm:	$(OBJS) $(HROOT)/cfunc/libcfunc.a $(HROOT)/fe/libfe.a \
		$(HROOT)/li/libhermi.a $(HROOT)/cherm/libcherm.a \
		$(HROOT)/lib/libhaux.a
	$(CC) -o $@ $(CFLAGS) $(OBJS) $(LIBS)	

lint:	asm
	$(LINT) $(LFLAGS) *.c

opfuncdefs.h oplex.lex: $(HROOT)/interface/greencard opcodes.awk
	awk -f opcodes.awk $(HROOT)/interface/greencard

asm.c: asm.y 
	$(YACC) -d $(YFLAGS) asm.y
	mv y.tab.c asm.c
	mv y.tab.h tokens.h

exceps.lex: $(HROOT)/interface/predefined.d
	awk -f exceps.awk $(HROOT)/interface/predefined.d >exceps.lex

asmlex.l: asmlex.lex oplex.lex exceps.lex
	m4 asmlex.lex >asmlex.l

asmlex.c: asmlex.l 
	lex -t asmlex.l >asmlex.c

actions.cd: actions.d
	$(CHGRAM) actions.d >actions.cd

actions.c: actions.ch actions.cd
	$(CHERM) actions.ch | $(CHERM2) >actions.c

defacts.c: defacts.ch 
	$(CHERM) defacts.ch | $(CHERM2) >defacts.c

clean::
	rm -f asm asm.c asmlex.l asmlex.c y.output exceps.lex tokens.h \
	  opfuncdefs.h oplex.lex defacts.c actions.c actions.cd

