/* Filename: TtyText.h */
/* Author: Andy Lowry */
/* SCCS Info: @(#)TtyText.h	1.1 6/18/90 */

#ifndef _TtyText_h
#define _TtyText_h

/****************************************************************
 *
 * TtyText widgets
 *
 ****************************************************************/

/* Resources:

 Name		     Class		RepType		Default Value
 ----		     -----		-------		-------------
 background	     Background		Pixel		XtDefaultBackground
 border		     BorderColor	Pixel		XtDefaultForeground
 borderWidth	     BorderWidth	Dimension	1
 destroyCallback     Callback		Pointer		NULL
 displayPosition     TextPosition	int		0
 editType	     EditType		XtTextEditType	XttextRead
 font		     Font		XFontStruct*	Fixed
 foreground	     Foreground		Pixel		Black
 height		     Height		Dimension	font height
 insertPosition	     TextPosition	int		0
 leftMargin	     Margin		Dimension	2
 length              Length             int		0
 mappedWhenManaged   MappedWhenManaged	Boolean		True
 maxLines            MaxLines           int             0
 selectTypes	     SelectTypes	Pointer		(internal)
 selection	     Selection		Pointer		empty selection
 sensitive	     Sensitive		Boolean		True
 string		     String		String		NULL
 textOptions	     TextOptions	int		0
 width		     Width		Dimension	100
 x		     Position		Position	0
 y		     Position		Position	0

*/


#include <X11/Text.h>		/* TtyText is a subclass of Text */

#define XtNstring		"string"
#define XtNlength		"length"

#define XtCString		"String"
#define XtCLength		"Length"

typedef struct _TtyTextClassRec		*TtyTextWidgetClass;
typedef struct _TtyTextRec		*TtyTextWidget;

extern WidgetClass ttyTextWidgetClass;

/* public routines */

extern void TtyTextAddText();	/* w, text */
    /* Widget w;		*/
    /* XtTextBlock *text;	*/

#endif  _TtyText_h
