-- (C) Copyright International Business Machines Corporation 23 January 
-- 1990.  All Rights Reserved. 
--  
-- See the file USERAGREEMENT distributed with this software for full 
-- terms and conditions of use. 
-- File: substobject.p
-- Author: Rob Strom
-- SCCS Info: @(#)substobject.p	1.2 3/13/90

substobject : USING( tscheck, Predefined  ) PROCESS (SubstituteInit : SubstituteInport )
-- procedure to substitute an objectname into a formal typestate
-- Algorithm:
-- For each attribute of the formal typestate, copy the attribute name
--   Then for each formal object, create an actual object whose
--   rootname comes from the objectname and whose components are
--   those of the objectname concatenated with those of the formal
  DECLARE
    FP: SubstituteCall ;
  BEGIN
    RECEIVE FP FROM SubstituteInit ;
    NEW FP.ActualTypestate;
    FOR FormalAttribute IN FP.FormalTypestate WHERE(boolean # 'true')
      INSPECT
        INSERT (EVALUATE ActualAttribute: Attribute FROM
          NEW ActualAttribute;
          ActualAttribute.Name := FormalAttribute.Attribute_Name;
          NEW ActualAttribute.Objects;
          FOR FormalObject IN FormalAttribute.Parameters WHERE(boolean # 'true')
            INSPECT
              INSERT (EVALUATE ActualObject: ObjectName FROM
                NEW ActualObject;
                ActualObject.Root := FP.Object.Root;
                ActualObject.Components <- component_list # (FP.Object.Components | FormalObject);
                END) INTO ActualAttribute.Objects;
            END FOR; /* once per object */
          END) INTO FP.ActualTypestate;
      END FOR; /* once per attribute */
    RETURN FP;
  END PROCESS
